/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.chain;

import cn.sliew.milky.common.chain.Context;
import cn.sliew.milky.common.chain.DefaultPipeline;
import cn.sliew.milky.common.chain.Pipeline;
import cn.sliew.milky.common.chain.PipelineProcess;
import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.common.exception.ThrowableTraceFormater;
import cn.sliew.milky.log.Logger;
import cn.sliew.milky.log.LoggerFactory;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public abstract class AbstractPipelineProcess<K, V>
implements PipelineProcess<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPipelineProcess.class);
    volatile AbstractPipelineProcess next;
    volatile AbstractPipelineProcess prev;
    private final DefaultPipeline pipeline;
    private final String name;
    final Executor executor;

    AbstractPipelineProcess(DefaultPipeline pipeline, Executor executor, String name) {
        this.name = Ensures.checkNotNull(name, () -> "name null");
        this.pipeline = pipeline;
        this.executor = executor;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Executor executor() {
        return this.executor;
    }

    @Override
    public Pipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public PipelineProcess<K, V> fireEvent(Context<K, V> context, CompletableFuture<?> future) {
        AbstractPipelineProcess.invokeEvent(this.next, context, future);
        return this;
    }

    @Override
    public PipelineProcess fireExceptionCaught(Context<K, V> context, CompletableFuture<?> future, Throwable cause) {
        AbstractPipelineProcess.invokeExceptionCaught(this.next, context, future, cause);
        return this;
    }

    static <K, V> void invokeEvent(AbstractPipelineProcess next, Context<K, V> context, CompletableFuture<?> future) {
        next.invokeEvent(context, future);
    }

    private void invokeEvent(Context<K, V> context, CompletableFuture<?> future) {
        try {
            this.command().onEvent(this, context, future);
        }
        catch (Throwable t) {
            this.invokeExceptionCaught(context, future, t);
        }
    }

    static <K, V> void invokeExceptionCaught(AbstractPipelineProcess next, Context<K, V> context, CompletableFuture<?> future, Throwable cause) {
        block2: {
            try {
                next.invokeExceptionCaught(context, future, cause);
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Failed to submit an exceptionCaught() event.", t);
                logger.warn("The exceptionCaught() event that was failed to submit was:", cause);
            }
        }
    }

    private void invokeExceptionCaught(Context<K, V> context, CompletableFuture<?> future, Throwable cause) {
        block3: {
            try {
                this.command().exceptionCaught(this, context, future, cause);
            }
            catch (Throwable error) {
                if (logger.isDebugEnabled()) {
                    logger.debug("An exception {} was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)ThrowableTraceFormater.readStackTrace(error), (Object)cause);
                }
                if (!logger.isWarnEnabled()) break block3;
                logger.warn("An exception '{}' [enable DEBUG level for full stacktrace] was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)error, (Object)cause);
            }
        }
    }

    public String toString() {
        return String.format("%s(%s, %s)", PipelineProcess.class.getSimpleName(), this.name(), this.command());
    }
}

