/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.unit;

import cn.sliew.milky.common.unit.TimeValues;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class TimeValue
implements Comparable<TimeValue> {
    public static final long NSEC_PER_MSEC = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS);
    public static final TimeValue MINUS_ONE = TimeValues.timeValueMillis(-1L);
    public static final TimeValue ZERO = TimeValues.timeValueMillis(0L);
    private final long duration;
    private final TimeUnit timeUnit;
    private static final long C0 = 1L;
    private static final long C1 = 1000L;
    private static final long C2 = 1000000L;
    private static final long C3 = 1000000000L;
    private static final long C4 = 60000000000L;
    private static final long C5 = 3600000000000L;
    private static final long C6 = 86400000000000L;

    public TimeValue(long millis) {
        this(millis, TimeUnit.MILLISECONDS);
    }

    public TimeValue(long duration, TimeUnit timeUnit) {
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    public long duration() {
        return this.duration;
    }

    public TimeUnit timeUnit() {
        return this.timeUnit;
    }

    public long nanos() {
        return this.timeUnit.toNanos(this.duration);
    }

    public long getNanos() {
        return this.nanos();
    }

    public long micros() {
        return this.timeUnit.toMicros(this.duration);
    }

    public long getMicros() {
        return this.micros();
    }

    public long millis() {
        return this.timeUnit.toMillis(this.duration);
    }

    public long getMillis() {
        return this.millis();
    }

    public long seconds() {
        return this.timeUnit.toSeconds(this.duration);
    }

    public long getSeconds() {
        return this.seconds();
    }

    public long minutes() {
        return this.timeUnit.toMinutes(this.duration);
    }

    public long getMinutes() {
        return this.minutes();
    }

    public long hours() {
        return this.timeUnit.toHours(this.duration);
    }

    public long getHours() {
        return this.hours();
    }

    public long days() {
        return this.timeUnit.toDays(this.duration);
    }

    public long getDays() {
        return this.days();
    }

    public double microsFrac() {
        return (double)this.nanos() / 1000.0;
    }

    public double getMicrosFrac() {
        return this.microsFrac();
    }

    public double millisFrac() {
        return (double)this.nanos() / 1000000.0;
    }

    public double getMillisFrac() {
        return this.millisFrac();
    }

    public double secondsFrac() {
        return (double)this.nanos() / 1.0E9;
    }

    public double getSecondsFrac() {
        return this.secondsFrac();
    }

    public double minutesFrac() {
        return (double)this.nanos() / 6.0E10;
    }

    public double getMinutesFrac() {
        return this.minutesFrac();
    }

    public double hoursFrac() {
        return (double)this.nanos() / 3.6E12;
    }

    public double getHoursFrac() {
        return this.hoursFrac();
    }

    public double daysFrac() {
        return (double)this.nanos() / 8.64E13;
    }

    public double getDaysFrac() {
        return this.daysFrac();
    }

    public String toString() {
        return this.toHumanReadableString(1);
    }

    public String toHumanReadableString(int fractionPieces) {
        if (this.duration < 0L) {
            return Long.toString(this.duration);
        }
        long nanos = this.nanos();
        if (nanos == 0L) {
            return "0s";
        }
        double value = nanos;
        String suffix = "nanos";
        if (nanos >= 86400000000000L) {
            value = this.daysFrac();
            suffix = "d";
        } else if (nanos >= 3600000000000L) {
            value = this.hoursFrac();
            suffix = "h";
        } else if (nanos >= 60000000000L) {
            value = this.minutesFrac();
            suffix = "m";
        } else if (nanos >= 1000000000L) {
            value = this.secondsFrac();
            suffix = "s";
        } else if (nanos >= 1000000L) {
            value = this.millisFrac();
            suffix = "ms";
        } else if (nanos >= 1000L) {
            value = this.microsFrac();
            suffix = "micros";
        }
        return TimeValue.formatDecimal(value, Math.min(10, Math.max(0, fractionPieces))) + suffix;
    }

    private static String formatDecimal(double value, int fractionPieces) {
        int position;
        long fractionValue;
        String p = String.valueOf(value);
        int totalLength = p.length();
        int ix = p.indexOf(46) + 1;
        int ex = p.indexOf(69);
        int fractionEnd = ex == -1 ? Math.min(ix + fractionPieces, totalLength) : ex;
        try {
            fractionValue = Long.parseLong(p.substring(ix, fractionEnd));
        }
        catch (NumberFormatException e) {
            fractionValue = 0L;
        }
        if (fractionValue == 0L || fractionPieces <= 0) {
            if (ex != -1) {
                return p.substring(0, ix - 1) + p.substring(ex);
            }
            return p.substring(0, ix - 1);
        }
        char[] fractions = new char[fractionPieces];
        int fracCount = 0;
        int truncateCount = 0;
        for (int i = 0; i < fractionPieces && (position = ix + i) < fractionEnd; ++i) {
            char fraction = p.charAt(position);
            truncateCount = fraction == '0' ? ++truncateCount : 0;
            fractions[i] = fraction;
            ++fracCount;
        }
        String fractionStr = new String(fractions, 0, fracCount - truncateCount);
        if (ex != -1) {
            return p.substring(0, ix) + fractionStr + p.substring(ex);
        }
        return p.substring(0, ix) + fractionStr;
    }

    public String getStringRep() {
        if (this.duration < 0L) {
            return Long.toString(this.duration);
        }
        switch (this.timeUnit) {
            case NANOSECONDS: {
                return this.duration + "nanos";
            }
            case MICROSECONDS: {
                return this.duration + "micros";
            }
            case MILLISECONDS: {
                return this.duration + "ms";
            }
            case SECONDS: {
                return this.duration + "s";
            }
            case MINUTES: {
                return this.duration + "m";
            }
            case HOURS: {
                return this.duration + "h";
            }
            case DAYS: {
                return this.duration + "d";
            }
        }
        throw new IllegalArgumentException("unknown time unit: " + this.timeUnit.name());
    }

    public static TimeValue parseTimeValue(String sValue) {
        Objects.requireNonNull(sValue);
        return TimeValue.parseTimeValue(sValue, null);
    }

    public static TimeValue parseTimeValue(String sValue, TimeValue defaultValue) {
        if (sValue == null) {
            return defaultValue;
        }
        String normalized = sValue.toLowerCase(Locale.ROOT).trim();
        if (normalized.endsWith("nanos")) {
            return new TimeValue(TimeValue.parse(sValue, normalized, "nanos"), TimeUnit.NANOSECONDS);
        }
        if (normalized.endsWith("micros")) {
            return new TimeValue(TimeValue.parse(sValue, normalized, "micros"), TimeUnit.MICROSECONDS);
        }
        if (normalized.endsWith("ms")) {
            return new TimeValue(TimeValue.parse(sValue, normalized, "ms"), TimeUnit.MILLISECONDS);
        }
        if (normalized.endsWith("s")) {
            return new TimeValue(TimeValue.parse(sValue, normalized, "s"), TimeUnit.SECONDS);
        }
        if (sValue.endsWith("m")) {
            return new TimeValue(TimeValue.parse(sValue, normalized, "m"), TimeUnit.MINUTES);
        }
        if (normalized.endsWith("h")) {
            return new TimeValue(TimeValue.parse(sValue, normalized, "h"), TimeUnit.HOURS);
        }
        if (normalized.endsWith("d")) {
            return new TimeValue(TimeValue.parse(sValue, normalized, "d"), TimeUnit.DAYS);
        }
        if (normalized.matches("-0*1")) {
            return MINUS_ONE;
        }
        if (normalized.matches("0+")) {
            return ZERO;
        }
        throw new IllegalArgumentException("failed to parse value [" + sValue + "] as a time value: unit is missing or unrecognized");
    }

    private static long parse(String initialInput, String normalized, String suffix) {
        String s = normalized.substring(0, normalized.length() - suffix.length()).trim();
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            try {
                double ignored = Double.parseDouble(s);
                throw new IllegalArgumentException("failed to parse [" + initialInput + "], fractional time values are not supported", e);
            }
            catch (NumberFormatException ignored) {
                throw new IllegalArgumentException("failed to parse [" + initialInput + "]", e);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((TimeValue)o) == 0;
    }

    public int hashCode() {
        return Double.hashCode((double)this.duration * (double)this.timeUnit.toNanos(1L));
    }

    public static long nsecToMSec(long ns) {
        return ns / NSEC_PER_MSEC;
    }

    @Override
    public int compareTo(TimeValue timeValue) {
        double thisValue = (double)this.duration * (double)this.timeUnit.toNanos(1L);
        double otherValue = (double)timeValue.duration * (double)timeValue.timeUnit.toNanos(1L);
        return Double.compare(thisValue, otherValue);
    }
}

