/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.environment;

import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.common.environment.PropertySource;
import cn.sliew.milky.log.Logger;
import cn.sliew.milky.log.LoggerFactory;
import java.util.Objects;

public abstract class AbstractPropertySource<T>
implements PropertySource<T> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final String name;
    protected final T source;

    public AbstractPropertySource(String name, T source) {
        this.name = Ensures.notBlank(name, () -> "Property source name can't be blank");
        this.source = Ensures.checkNotNull(source, () -> "Property source object must not be null");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T getSource() {
        return this.source;
    }

    @Override
    public boolean containsProperty(String property) {
        return this.getProperty(property).isPresent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPropertySource that = (AbstractPropertySource)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        if (this.log.isDebugEnabled()) {
            return this.getClass().getSimpleName() + "@" + System.identityHashCode(this) + " {name='" + this.getName() + "', properties=" + this.getSource() + "}";
        }
        return this.getClass().getSimpleName() + " {name='" + this.getName() + "'}";
    }
}

