/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.event.simple;

import cn.sliew.milky.event.simple.EventConsumer;
import cn.sliew.milky.event.simple.EventPublisher;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class DefaultEventPublisher<T>
implements EventPublisher<T> {
    private final List<EventConsumer<T>> onEventConsumers = new CopyOnWriteArrayList<EventConsumer<T>>();
    private final ConcurrentMap<Class, List<EventConsumer<T>>> eventConsumerMap = new ConcurrentHashMap<Class, List<EventConsumer<T>>>();
    private volatile boolean consumerRegistered;

    public boolean hasConsumers() {
        return this.consumerRegistered;
    }

    @Override
    public synchronized void registerEventConsumer(Class<T> eventClazz, EventConsumer<T> onEventConsumer) {
        this.consumerRegistered = true;
        this.eventConsumerMap.compute(eventClazz, (key, consumers) -> {
            if (consumers == null) {
                consumers = new LinkedList<EventConsumer>();
            }
            consumers.add(onEventConsumer);
            return consumers;
        });
    }

    @Override
    public void registerGenericConsumer(EventConsumer<T> onEventConsumer) {
        this.consumerRegistered = true;
        this.onEventConsumers.add(onEventConsumer);
    }

    @Override
    public boolean publishEvent(T event) {
        List eventConsumers;
        boolean consumed = false;
        if (!this.onEventConsumers.isEmpty()) {
            this.onEventConsumers.forEach(onEventConsumer -> onEventConsumer.onEvent(event));
            consumed = true;
        }
        if (!this.eventConsumerMap.isEmpty() && (eventConsumers = (List)this.eventConsumerMap.get(event.getClass())) != null && !eventConsumers.isEmpty()) {
            eventConsumers.forEach(consumer -> consumer.onEvent(event));
            consumed = true;
        }
        return consumed;
    }
}

