/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.log;

import cn.sliew.milky.log.Log4J2LoggerFactory;
import cn.sliew.milky.log.Logger;
import cn.sliew.milky.log.NoLoggerFactory;
import cn.sliew.milky.log.Slf4jLoggerFactory;

public abstract class LoggerFactory {
    private static volatile LoggerFactory defaultFactory;

    private static LoggerFactory newDefaultFactory(String name) {
        LoggerFactory f;
        try {
            f = new Slf4jLoggerFactory(true);
            f.newInstance(name).debug("Using SLF4J as the default logging framework");
        }
        catch (Throwable ignore1) {
            try {
                f = Log4J2LoggerFactory.INSTANCE;
                f.newInstance(name).debug("Using Log4J2 as the default logging framework");
            }
            catch (Throwable ignore2) {
                f = NoLoggerFactory.INSTANCE;
                f.newInstance(name).debug("Using NoLog as the default logging framework");
            }
        }
        return f;
    }

    public static LoggerFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = LoggerFactory.newDefaultFactory(LoggerFactory.class.getName());
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(LoggerFactory defaultFactory) {
        if (defaultFactory == null) {
            throw new NullPointerException("defaultFactory");
        }
        LoggerFactory.defaultFactory = defaultFactory;
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name) {
        return LoggerFactory.getDefaultFactory().newInstance(name);
    }

    protected abstract Logger newInstance(String var1);
}

