/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.io.stream;

import cn.sliew.milky.common.io.stream.InputStreamStreamInput;
import cn.sliew.milky.common.util.BitUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class StreamInput
extends InputStream {
    public static StreamInput wrap(byte[] bytes) {
        return StreamInput.wrap(bytes, 0, bytes.length);
    }

    public static StreamInput wrap(byte[] bytes, int offset, int length) {
        return new InputStreamStreamInput(new ByteArrayInputStream(bytes, offset, length));
    }

    @Override
    public abstract void close() throws IOException;

    @Override
    public abstract int available() throws IOException;

    public abstract byte readByte() throws IOException;

    public abstract void readBytes(byte[] var1, int var2, int var3) throws IOException;

    public short readShort() throws IOException {
        return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
    }

    public int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public Integer readOptionalInt() throws IOException {
        if (this.readBoolean()) {
            return this.readInt();
        }
        return null;
    }

    public int readVInt() throws IOException {
        byte b = this.readByte();
        int i = b & 0x7F;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        if ((b & 0x80) != 0) {
            throw new IOException("Invalid vInt ((" + Integer.toHexString(b) + " & 0x7f) << 28) | " + Integer.toHexString(i));
        }
        return i | (b & 0x7F) << 28;
    }

    public @Nullable Integer readOptionalVInt() throws IOException {
        if (this.readBoolean()) {
            return this.readVInt();
        }
        return null;
    }

    public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public @Nullable Long readOptionalLong() throws IOException {
        if (this.readBoolean()) {
            return this.readLong();
        }
        return null;
    }

    public long readVLong() throws IOException {
        byte b = this.readByte();
        long i = (long)b & 0x7FL;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 28;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 35;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 42;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 49;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 56;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        if (b != 0 && b != 1) {
            throw new IOException("Invalid vlong (" + Integer.toHexString(b) + " << 63) | " + Long.toHexString(i));
        }
        return i |= (long)b << 63;
    }

    public @Nullable Long readOptionalVLong() throws IOException {
        if (this.readBoolean()) {
            return this.readVLong();
        }
        return null;
    }

    public long readZLong() throws IOException {
        long currentByte;
        long accumulator = 0L;
        int i = 0;
        while (((currentByte = (long)this.readByte()) & 0x80L) != 0L) {
            accumulator |= (currentByte & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw new IOException("variable-length stream is too long");
        }
        return BitUtil.zigZagDecode(accumulator | currentByte << i);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public @Nullable Float readOptionalFloat() throws IOException {
        if (this.readBoolean()) {
            return Float.valueOf(this.readFloat());
        }
        return null;
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final @Nullable Double readOptionalDouble() throws IOException {
        if (this.readBoolean()) {
            return this.readDouble();
        }
        return null;
    }

    public final boolean readBoolean() throws IOException {
        return this.readBoolean(this.readByte());
    }

    private boolean readBoolean(byte value) {
        if (value == 0) {
            return false;
        }
        if (value == 1) {
            return true;
        }
        String message = String.format(Locale.ROOT, "unexpected byte [0x%02x]", value);
        throw new IllegalStateException(message);
    }

    public final @Nullable Boolean readOptionalBoolean() throws IOException {
        byte value = this.readByte();
        if (value == 2) {
            return null;
        }
        return this.readBoolean(value);
    }

    public @Nullable Object readGenericValue() throws IOException {
        byte type = this.readByte();
        switch (type) {
            case -1: {
                return null;
            }
            case 0: {
                return this.readByte();
            }
            case 1: {
                return this.readShort();
            }
            case 2: {
                return this.readInt();
            }
            case 3: {
                return this.readLong();
            }
            case 4: {
                return Float.valueOf(this.readFloat());
            }
            case 5: {
                return this.readDouble();
            }
            case 6: {
                return this.readBoolean();
            }
        }
        throw new IOException("Can't read unknown type [" + type + "]");
    }
}

