/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.chain;

import cn.sliew.milky.common.chain.AbstractPipelineProcess;
import cn.sliew.milky.common.chain.Command;
import cn.sliew.milky.common.chain.Context;
import cn.sliew.milky.common.chain.DefaultPipelineProcess;
import cn.sliew.milky.common.chain.Pipeline;
import cn.sliew.milky.common.chain.PipelineException;
import cn.sliew.milky.common.chain.PipelineProcess;
import cn.sliew.milky.log.Logger;
import cn.sliew.milky.log.LoggerFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class DefaultPipeline<K, V>
implements Pipeline<K, V> {
    static final Logger logger = LoggerFactory.getLogger(DefaultPipeline.class);
    private static final String HEAD_NAME = "HeadContext#0";
    private static final String TAIL_NAME = "TailContext#0";
    final AbstractPipelineProcess head;
    final AbstractPipelineProcess tail;
    final Executor executor = Executors.newFixedThreadPool(2);

    public DefaultPipeline() {
        this.tail = new TailContext(this);
        this.head = new HeadContext(this);
        this.head.next = this.tail;
        this.tail.prev = this.head;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pipeline addFirst(String name, Command command) {
        DefaultPipeline defaultPipeline = this;
        synchronized (defaultPipeline) {
            this.checkDuplicateName(name);
            AbstractPipelineProcess newCtx = this.newContext(this.executor, name, command);
            this.addFirst0(newCtx);
        }
        return this;
    }

    private void addFirst0(AbstractPipelineProcess newCtx) {
        AbstractPipelineProcess nextCtx = this.head.next;
        newCtx.prev = this.head;
        newCtx.next = nextCtx;
        this.head.next = newCtx;
        nextCtx.prev = newCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pipeline addLast(String name, Command command) {
        DefaultPipeline defaultPipeline = this;
        synchronized (defaultPipeline) {
            this.checkDuplicateName(name);
            AbstractPipelineProcess newCtx = this.newContext(this.executor, name, command);
            this.addLast0(newCtx);
        }
        return this;
    }

    private void addLast0(AbstractPipelineProcess newCtx) {
        AbstractPipelineProcess prev;
        newCtx.prev = prev = this.tail.prev;
        newCtx.next = this.tail;
        prev.next = newCtx;
        this.tail.prev = newCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pipeline addBefore(String baseName, String name, Command command) {
        DefaultPipeline defaultPipeline = this;
        synchronized (defaultPipeline) {
            this.checkDuplicateName(name);
            AbstractPipelineProcess ctx = this.getContextOrDie(baseName);
            AbstractPipelineProcess newCtx = this.newContext(this.executor, name, command);
            DefaultPipeline.addBefore0(ctx, newCtx);
        }
        return this;
    }

    private static void addBefore0(AbstractPipelineProcess ctx, AbstractPipelineProcess newCtx) {
        newCtx.prev = ctx.prev;
        newCtx.next = ctx;
        ctx.prev.next = newCtx;
        ctx.prev = newCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pipeline addAfter(String baseName, String name, Command command) {
        DefaultPipeline defaultPipeline = this;
        synchronized (defaultPipeline) {
            this.checkDuplicateName(name);
            AbstractPipelineProcess ctx = this.getContextOrDie(baseName);
            AbstractPipelineProcess newCtx = this.newContext(this.executor, name, command);
            DefaultPipeline.addAfter0(ctx, newCtx);
        }
        return this;
    }

    private static void addAfter0(AbstractPipelineProcess ctx, AbstractPipelineProcess newCtx) {
        newCtx.prev = ctx;
        newCtx.next = ctx.next;
        ctx.next.prev = newCtx;
        ctx.next = newCtx;
    }

    @Override
    public Pipeline remove(Command command) {
        this.remove(this.getContextOrDie(command));
        return this;
    }

    @Override
    public Command remove(String name) {
        return this.remove(this.getContextOrDie(name)).command();
    }

    @Override
    public final Command remove(Class commandType) {
        return this.remove(this.getContextOrDie(commandType)).command();
    }

    @Override
    public Command removeFirst() {
        if (this.head.next == this.tail) {
            throw new NoSuchElementException();
        }
        return this.remove(this.head.next).command();
    }

    @Override
    public Command removeLast() {
        if (this.head.next == this.tail) {
            throw new NoSuchElementException();
        }
        return this.remove(this.tail.prev).command();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractPipelineProcess remove(AbstractPipelineProcess ctx) {
        DefaultPipeline defaultPipeline = this;
        synchronized (defaultPipeline) {
            this.atomicRemoveFromHandlerList(ctx);
        }
        return ctx;
    }

    private synchronized void atomicRemoveFromHandlerList(AbstractPipelineProcess ctx) {
        AbstractPipelineProcess next;
        AbstractPipelineProcess prev = ctx.prev;
        prev.next = next = ctx.next;
        next.prev = prev;
    }

    @Override
    public Command first() {
        PipelineProcess first = this.firstContext();
        if (first == null) {
            return null;
        }
        return first.command();
    }

    @Override
    public Command last() {
        AbstractPipelineProcess last = this.tail.prev;
        if (last == this.head) {
            return null;
        }
        return last.command();
    }

    @Override
    public Command get(String name) {
        PipelineProcess ctx = this.context(name);
        if (ctx == null) {
            return null;
        }
        return ctx.command();
    }

    @Override
    public Command get(Class commandType) {
        PipelineProcess ctx = this.context(commandType);
        if (ctx == null) {
            return null;
        }
        return ctx.command();
    }

    @Override
    public PipelineProcess firstContext() {
        AbstractPipelineProcess first = this.head.next;
        if (first == this.tail) {
            return null;
        }
        return this.head.next;
    }

    @Override
    public PipelineProcess lastContext() {
        AbstractPipelineProcess last = this.tail.prev;
        if (last == this.head) {
            return null;
        }
        return last;
    }

    @Override
    public PipelineProcess context(Command command) {
        AbstractPipelineProcess ctx = this.head.next;
        while (ctx != null) {
            if (ctx.command() == command) {
                return ctx;
            }
            ctx = ctx.next;
        }
        return null;
    }

    @Override
    public PipelineProcess context(String name) {
        return this.context0(name);
    }

    @Override
    public PipelineProcess context(Class commandType) {
        AbstractPipelineProcess ctx = this.head.next;
        while (ctx != null) {
            if (commandType.isAssignableFrom(ctx.command().getClass())) {
                return ctx;
            }
            ctx = ctx.next;
        }
        return null;
    }

    @Override
    public List<String> names() {
        ArrayList<String> list = new ArrayList<String>();
        AbstractPipelineProcess ctx = this.head.next;
        while (ctx != null) {
            list.add(ctx.name());
            ctx = ctx.next;
        }
        return list;
    }

    @Override
    public Map<String, Command<K, V>> toMap() {
        LinkedHashMap map = new LinkedHashMap();
        AbstractPipelineProcess ctx = this.head.next;
        while (ctx != this.tail) {
            map.put(ctx.name(), ctx.command());
            ctx = ctx.next;
        }
        return map;
    }

    @Override
    public Pipeline fireEvent(Context<K, V> context, CompletableFuture<?> future) {
        AbstractPipelineProcess.invokeEvent(this.head, context, future);
        return this;
    }

    @Override
    public Pipeline fireExceptionCaught(Context<K, V> context, Throwable cause, CompletableFuture<?> future) {
        AbstractPipelineProcess.invokeExceptionCaught(this.head, context, future, cause);
        return this;
    }

    private AbstractPipelineProcess newContext(Executor executor, String name, Command command) {
        return new DefaultPipelineProcess(this, executor, name, command);
    }

    private AbstractPipelineProcess context0(String name) {
        AbstractPipelineProcess context = this.head.next;
        while (context != this.tail) {
            if (context.name().equals(name)) {
                return context;
            }
            context = context.next;
        }
        return null;
    }

    private AbstractPipelineProcess getContextOrDie(String name) {
        AbstractPipelineProcess ctx = (AbstractPipelineProcess)this.context(name);
        if (ctx == null) {
            throw new NoSuchElementException(name);
        }
        return ctx;
    }

    private AbstractPipelineProcess getContextOrDie(Command command) {
        AbstractPipelineProcess ctx = (AbstractPipelineProcess)this.context(command);
        if (ctx == null) {
            throw new NoSuchElementException(command.getClass().getName());
        }
        return ctx;
    }

    private AbstractPipelineProcess getContextOrDie(Class<? extends Command> commandType) {
        AbstractPipelineProcess ctx = (AbstractPipelineProcess)this.context((Class)commandType);
        if (ctx == null) {
            throw new NoSuchElementException(commandType.getName());
        }
        return ctx;
    }

    private void checkDuplicateName(String name) {
        if (this.context0(name) != null) {
            throw new IllegalArgumentException("Duplicate command name: " + name);
        }
    }

    public final String toString() {
        StringBuilder buf = new StringBuilder().append(this.getClass().getSimpleName()).append('{');
        AbstractPipelineProcess ctx = this.head.next;
        while (ctx != this.tail) {
            buf.append('(').append(ctx.name()).append(" = ").append(ctx.command().getClass().getName()).append(')');
            ctx = ctx.next;
            if (ctx == this.tail) break;
            buf.append(", ");
        }
        buf.append('}');
        return buf.toString();
    }

    final class HeadContext
    extends AbstractPipelineProcess
    implements Command {
        HeadContext(DefaultPipeline pipeline) {
            super(pipeline, null, DefaultPipeline.HEAD_NAME);
        }

        @Override
        public Command command() {
            return this;
        }

        public void onEvent(AbstractPipelineProcess process, Context context, CompletableFuture future) {
            process.fireEvent(context, future);
        }

        public void exceptionCaught(AbstractPipelineProcess process, Context context, CompletableFuture future, Throwable cause) throws PipelineException {
            process.fireExceptionCaught(context, future, cause);
        }

        @Override
        public String toString() {
            return String.format("%s(%s, %s)", PipelineProcess.class.getSimpleName(), this.name(), HeadContext.class.getCanonicalName());
        }
    }

    final class TailContext
    extends AbstractPipelineProcess
    implements Command {
        TailContext(DefaultPipeline pipeline) {
            super(pipeline, null, DefaultPipeline.TAIL_NAME);
        }

        @Override
        public Command command() {
            return this;
        }

        public void onEvent(AbstractPipelineProcess process, Context context, CompletableFuture future) {
            if (future.isDone() || future.isCancelled()) {
                logger.warn("finished or cancelled event! process: {}, context: {}", (Object)process, (Object)context);
            } else {
                logger.warn("unhandled event triggered! process: {}, context: {}", (Object)process, (Object)context);
                future.complete(null);
            }
        }

        public void exceptionCaught(AbstractPipelineProcess process, Context context, CompletableFuture future, Throwable cause) throws PipelineException {
            logger.warn("An exceptionCaught() event was fired, and it reached at the tail of the pipeline. It usually means the last handler in the pipeline did not handle the exception. context: {}", (Object)context, (Object)cause);
            future.completeExceptionally(cause);
        }

        @Override
        public String toString() {
            return String.format("%s(%s, %s)", PipelineProcess.class.getSimpleName(), this.name(), TailContext.class.getCanonicalName());
        }
    }
}

