/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.registry;

import cn.sliew.milky.common.registry.InMemoryRegistryStore;
import cn.sliew.milky.common.registry.Registry;
import cn.sliew.milky.common.registry.RegistryStore;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public abstract class AbstractRegistry<E, C>
implements Registry<E, C> {
    protected static final String DEFAULT_CONFIG = "default";
    protected final RegistryStore<E> entryMap;
    protected final ConcurrentMap<String, C> configurations = new ConcurrentHashMap<String, C>();

    public AbstractRegistry(C defaultConfig) {
        this.entryMap = new InMemoryRegistryStore();
        this.configurations.put(DEFAULT_CONFIG, Objects.requireNonNull(defaultConfig, "Config must not be null"));
    }

    protected E computeIfAbsent(String name, Supplier<E> supplier) {
        return (E)this.entryMap.computeIfAbsent(Objects.requireNonNull(name, "Name must not be null"), (? super String k) -> supplier.get());
    }

    @Override
    public Optional<E> find(String name) {
        return this.entryMap.find(name);
    }

    @Override
    public Optional<E> remove(String name) {
        return this.entryMap.remove(name);
    }

    @Override
    public Optional<E> replace(String name, E newEntry) {
        return this.entryMap.replace(name, newEntry);
    }

    @Override
    public void addConfiguration(String configName, C configuration) {
        if (configName.equals(DEFAULT_CONFIG)) {
            throw new IllegalArgumentException("You cannot use 'default' as a configuration name as it is preserved for default configuration");
        }
        this.configurations.put(configName, configuration);
    }

    @Override
    public Optional<C> getConfiguration(String configName) {
        return Optional.ofNullable(this.configurations.get(configName));
    }

    @Override
    public C getDefaultConfig() {
        return (C)this.configurations.get(DEFAULT_CONFIG);
    }
}

