/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.settings;

import cn.sliew.milky.common.parse.placeholder.PropertyPlaceholder;
import cn.sliew.milky.common.primitives.Strings;
import cn.sliew.milky.common.settings.Settings;
import cn.sliew.milky.log.Logger;
import cn.sliew.milky.log.LoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;

public class SettingsBuilder {
    private static final Logger log = LoggerFactory.getLogger(SettingsBuilder.class);
    public static final Settings EMPTY_SETTINGS = new SettingsBuilder().build();
    private final Map<String, Object> map = new TreeMap<String, Object>();

    SettingsBuilder() {
    }

    public String remove(String key) {
        return Settings.toString(this.map.remove(key));
    }

    public String get(String key) {
        return Settings.toString(this.map.get(key));
    }

    public SettingsBuilder putNull(String key) {
        return this.put(key, null);
    }

    public SettingsBuilder put(String key, String value) {
        this.map.put(key, value);
        return this;
    }

    public SettingsBuilder put(String setting, float value) {
        this.put(setting, String.valueOf(value));
        return this;
    }

    public SettingsBuilder put(String setting, double value) {
        this.put(setting, String.valueOf(value));
        return this;
    }

    public SettingsBuilder put(String setting, int value) {
        this.put(setting, String.valueOf(value));
        return this;
    }

    public SettingsBuilder put(String setting, long value) {
        this.put(setting, String.valueOf(value));
        return this;
    }

    public SettingsBuilder put(String setting, boolean value) {
        this.put(setting, String.valueOf(value));
        return this;
    }

    public SettingsBuilder putList(String setting, String ... values) {
        return this.putList(setting, Arrays.asList(values));
    }

    public SettingsBuilder putList(String setting, List<String> values) {
        this.remove(setting);
        this.map.put(setting, new ArrayList<String>(values));
        return this;
    }

    public SettingsBuilder put(Settings settings) {
        HashMap<String, Object> settingsMap = new HashMap<String, Object>(settings.settings);
        this.map.putAll(settingsMap);
        return this;
    }

    public SettingsBuilder copy(String key, Settings source) {
        return this.copy(key, key, source);
    }

    public SettingsBuilder copy(String key, String sourceKey, Settings source) {
        if (!source.settings.containsKey(sourceKey)) {
            throw new IllegalArgumentException("source key not found in the source settings");
        }
        Object value = source.settings.get(sourceKey);
        if (value instanceof List) {
            return this.putList(key, (List)value);
        }
        if (value == null) {
            return this.putNull(key);
        }
        return this.put(key, Settings.toString(value));
    }

    public SettingsBuilder replacePropertyPlaceholders() {
        return this.replacePropertyPlaceholders(System::getenv);
    }

    SettingsBuilder replacePropertyPlaceholders(final Function<String, String> getenv) {
        PropertyPlaceholder propertyPlaceholder = new PropertyPlaceholder(log, "${", "}", ":", false);
        PropertyPlaceholder.PlaceholderResolver placeholderResolver = new PropertyPlaceholder.PlaceholderResolver(){

            @Override
            public Optional<String> resolvePlaceholder(String placeholderName) {
                String value = (String)getenv.apply(placeholderName);
                if (value != null) {
                    return Optional.of(value);
                }
                return Optional.ofNullable(Settings.toString(SettingsBuilder.this.map.get(placeholderName)));
            }

            @Override
            public boolean shouldIgnoreMissing(String placeholderName) {
                return false;
            }

            @Override
            public boolean shouldRemoveMissingPlaceholder(String placeholderName) {
                return true;
            }
        };
        Iterator<Map.Entry<String, Object>> entryItr = this.map.entrySet().iterator();
        while (entryItr.hasNext()) {
            Map.Entry<String, Object> entry = entryItr.next();
            if (entry.getValue() == null) continue;
            if (entry.getValue() instanceof List) {
                ListIterator<String> li = ((List)entry.getValue()).listIterator();
                while (li.hasNext()) {
                    String settingValueRaw = (String)li.next();
                    String settingValueResolved = propertyPlaceholder.replacePlaceholders(settingValueRaw, placeholderResolver);
                    li.set(settingValueResolved);
                }
                continue;
            }
            String value = propertyPlaceholder.replacePlaceholders(Settings.toString(entry.getValue()), placeholderResolver);
            if (Strings.hasLength(value)) {
                entry.setValue(value);
                continue;
            }
            entryItr.remove();
        }
        return this;
    }

    public Settings build() {
        return new Settings(this.map);
    }
}

