/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.primitives;

import cn.sliew.milky.common.primitives.Strings;

public final class Longs {
    private Longs() {
        throw new AssertionError((Object)"No instances intended");
    }

    public static long parseLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Failed to parse long value [%s]", value));
        }
    }

    public static long parseLong(String value, long defaultValue) {
        if (Strings.hasText(value)) {
            return Longs.parseLong(value);
        }
        return defaultValue;
    }

    public static Long parseLong(String value, Long defaultValue) {
        if (Strings.hasText(value)) {
            return Longs.parseLong(value);
        }
        return defaultValue;
    }
}

