/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.parse;

import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.common.parse.TokenFormat;
import cn.sliew.milky.common.parse.TokenParseException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class Token
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -485514933964341727L;
    private final TokenFormat tokenFormat;
    private final List<TokenFormat.Segment> segments;
    private transient int hashCode;
    private transient SoftReference<String> toString;

    public static Token parse(String token) throws TokenParseException {
        Ensures.notBlank(token, () -> "Token string must not be null or blank");
        return TokenFormat.getDefault().parse(token);
    }

    public static Token root(String segmentType, String value) {
        return new Token(TokenFormat.getDefault(), new TokenFormat.Segment(segmentType, value));
    }

    private Token(TokenFormat tokenFormat, TokenFormat.Segment segment) {
        this(tokenFormat, Collections.singletonList(segment));
    }

    Token(TokenFormat tokenFormat, List<TokenFormat.Segment> segments) {
        this.tokenFormat = tokenFormat;
        this.segments = segments;
    }

    final Optional<TokenFormat.Segment> getRoot() {
        return this.segments.isEmpty() ? Optional.empty() : Optional.of(this.segments.get(0));
    }

    public final List<TokenFormat.Segment> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public final Token append(String segmentType, String value) {
        return this.append(new TokenFormat.Segment(segmentType, value));
    }

    public final Token append(TokenFormat.Segment segment) {
        Ensures.checkNotNull(segment, () -> "segment must not be null");
        ArrayList<TokenFormat.Segment> baseSegments = new ArrayList<TokenFormat.Segment>(this.segments.size() + 1);
        baseSegments.addAll(this.segments);
        baseSegments.add(segment);
        return new Token(this.tokenFormat, baseSegments);
    }

    public boolean hasPrefix(Token potentialPrefix) {
        Ensures.checkNotNull(potentialPrefix, () -> "potentialPrefix must not be null");
        int size = this.segments.size();
        int prefixSize = potentialPrefix.segments.size();
        return size >= prefixSize && this.segments.subList(0, prefixSize).equals(potentialPrefix.segments);
    }

    public Token removeLastSegment() {
        Ensures.checkState(this.segments.size() > 1, () -> "Cannot remove last remaining segment");
        return new Token(this.tokenFormat, new ArrayList<TokenFormat.Segment>(this.segments.subList(0, this.segments.size() - 1)));
    }

    public TokenFormat.Segment getLastSegment() {
        return this.segments.get(this.segments.size() - 1);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token that = (Token)o;
        return this.segments.equals(that.segments);
    }

    public int hashCode() {
        int value = this.hashCode;
        if (value == 0) {
            value = this.segments.hashCode();
            if (value == 0) {
                value = 1;
            }
            this.hashCode = value;
        }
        return value;
    }

    public String toString() {
        String value;
        SoftReference<String> s = this.toString;
        String string = value = s == null ? null : s.get();
        if (value == null) {
            value = this.tokenFormat.format(this);
            this.toString = new SoftReference<String>(value);
        }
        return value;
    }
}

