/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.concurrent;

import cn.sliew.milky.concurrent.AbstractFuture;
import cn.sliew.milky.concurrent.Future;
import cn.sliew.milky.concurrent.FutureListener;
import java.util.concurrent.TimeUnit;

public abstract class CompleteFuture<V>
extends AbstractFuture<V> {
    @Override
    public Future<V> addListener(FutureListener<? extends Future<? super V>> listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.notifyListener0(this, listener);
        return this;
    }

    @Override
    public Future<V> removeListener(FutureListener<? extends Future<? super V>> listener) {
        return this;
    }

    private void notifyListener0(Future future, FutureListener listener) {
        try {
            listener.onComplete(future);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public Future<V> sync() throws InterruptedException {
        return this;
    }

    @Override
    public Future<V> await() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return true;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }
}

