/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.concurrent;

import cn.sliew.milky.concurrent.DefaultPromise;
import cn.sliew.milky.concurrent.Future;
import cn.sliew.milky.concurrent.FutureListener;
import cn.sliew.milky.concurrent.ProgressiveFuture;
import cn.sliew.milky.concurrent.ProgressiveFutureListener;
import cn.sliew.milky.concurrent.ProgressivePromise;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DefaultProgressivePromise<V>
extends DefaultPromise<V>
implements ProgressivePromise<V> {
    @Override
    public ProgressivePromise<V> setProgress(long progress, long total) {
        if (total < 0L) {
            total = -1L;
            if (progress < 0L) {
                throw new IllegalArgumentException("progress: " + progress + " (expected: >= 0)");
            }
        } else if (progress < 0L || progress > total) {
            throw new IllegalArgumentException("progress: " + progress + " (expected: 0 <= progress <= total (" + total + "))");
        }
        if (this.isDone()) {
            throw new IllegalStateException("complete already");
        }
        this.notifyProgressiveListeners(progress, total);
        return this;
    }

    @Override
    public boolean tryProgress(long progress, long total) {
        if (total < 0L) {
            total = -1L;
            if (progress < 0L || this.isDone()) {
                return false;
            }
        } else if (progress < 0L || progress > total || this.isDone()) {
            return false;
        }
        this.notifyProgressiveListeners(progress, total);
        return true;
    }

    void notifyProgressiveListeners(long progress, long total) {
        List<ProgressiveFutureListener> listeners = this.progressiveListeners();
        if (listeners.isEmpty()) {
            return;
        }
        listeners.forEach(listener -> DefaultProgressivePromise.notifyProgressiveListener0(this, listener, progress, total));
    }

    private synchronized List<ProgressiveFutureListener> progressiveListeners() {
        List listeners = this.listeners;
        if (listeners == null || listeners.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<ProgressiveFutureListener> progressiveFutureListeners = new LinkedList<ProgressiveFutureListener>();
        for (FutureListener listener : listeners) {
            if (!(listener instanceof ProgressiveFutureListener)) continue;
            progressiveFutureListeners.add((ProgressiveFutureListener)listener);
        }
        return progressiveFutureListeners;
    }

    private static void notifyProgressiveListener0(ProgressiveFuture future, ProgressiveFutureListener listener, long progress, long total) {
        try {
            listener.onProgressed(future, progress, total);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public ProgressivePromise<V> setSuccess(V result) {
        super.setSuccess(result);
        return this;
    }

    @Override
    public ProgressivePromise<V> setFailure(Throwable cause) {
        super.setFailure(cause);
        return this;
    }

    @Override
    public ProgressivePromise<V> addListener(FutureListener<? extends Future<? super V>> listener) {
        super.addListener((FutureListener)listener);
        return this;
    }

    @Override
    public ProgressivePromise<V> removeListener(FutureListener<? extends Future<? super V>> listener) {
        super.removeListener((FutureListener)listener);
        return this;
    }

    @Override
    public ProgressivePromise<V> sync() throws InterruptedException {
        super.sync();
        return this;
    }

    @Override
    public ProgressivePromise<V> await() throws InterruptedException {
        super.await();
        return this;
    }
}

