/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.exception;

import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.log.Logger;
import cn.sliew.milky.log.LoggerFactory;
import java.util.concurrent.Callable;
import java.util.function.Function;

public final class Rethrower {
    private static final Logger log = LoggerFactory.getLogger(Rethrower.class);

    private Rethrower() {
        throw new AssertionError((Object)"No instance intended");
    }

    public static void rethrowIfUnrecoverable(Throwable exception) {
        if (exception instanceof OutOfMemoryError) {
            Rethrower.throwAsUncheckedException(exception);
        }
    }

    public static RuntimeException throwAsUncheckedException(Throwable t) {
        Ensures.checkNotNull(t, () -> "Throwable must not be null");
        Rethrower.throwAs(t);
        return null;
    }

    public static <T extends Throwable> void throwAs(Throwable t) throws T {
        throw t;
    }

    public static <T> T toRuntime(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void toRuntime(Procedure voidCallable) {
        Rethrower.castCheckedToRuntime(voidCallable, RuntimeException::new);
    }

    public static void toIllegalState(Procedure voidCallable) {
        Rethrower.castCheckedToRuntime(voidCallable, IllegalStateException::new);
    }

    public static void toIllegalArgument(Procedure voidCallable) {
        Rethrower.castCheckedToRuntime(voidCallable, IllegalArgumentException::new);
    }

    private static void castCheckedToRuntime(Procedure voidCallable, Function<Exception, RuntimeException> exceptionFactory) {
        try {
            voidCallable.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw exceptionFactory.apply(e);
        }
    }

    public static void swallow(Procedure procedure) {
        try {
            procedure.call();
        }
        catch (Exception e) {
            log.error("Swallowed error.", e);
        }
    }

    public static interface Procedure {
        public void call() throws Exception;
    }
}

