/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.primitives;

import cn.sliew.milky.common.primitives.Strings;

public final class Integers {
    private Integers() {
        throw new AssertionError((Object)"No instances intended");
    }

    public static int parseInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Failed to parse int value [%s]", value));
        }
    }

    public static int parseInteger(String value, int defaultValue) {
        if (Strings.hasText(value)) {
            return Integers.parseInteger(value);
        }
        return defaultValue;
    }

    public static Integer parseInteger(String value, Integer defaultValue) {
        if (Strings.hasText(value)) {
            return Integers.parseInteger(value);
        }
        return defaultValue;
    }
}

