/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.regex;

import cn.sliew.milky.common.primitives.Strings;

public final class Regex {
    private Regex() {
        throw new AssertionError((Object)"No instances intended");
    }

    public static boolean simpleMatch(String pattern, String str) {
        return Regex.simpleMatch(pattern, str, false);
    }

    public static boolean simpleMatch(String pattern, String str, boolean caseInsensitive) {
        if (pattern == null || str == null) {
            return false;
        }
        if (caseInsensitive) {
            pattern = Strings.toLowercaseAscii(pattern);
            str = Strings.toLowercaseAscii(str);
        }
        return Regex.simpleMatchWithNormalizedStrings(pattern, str);
    }

    private static boolean simpleMatchWithNormalizedStrings(String pattern, String str) {
        int firstIndex = pattern.indexOf(42);
        if (firstIndex == -1) {
            return pattern.equals(str);
        }
        if (firstIndex == 0) {
            if (pattern.length() == 1) {
                return true;
            }
            int nextIndex = pattern.indexOf(42, firstIndex + 1);
            if (nextIndex == -1) {
                return str.regionMatches(str.length() - pattern.length() + 1, pattern, 1, pattern.length() - 1);
            }
            if (nextIndex == 1) {
                return Regex.simpleMatchWithNormalizedStrings(pattern.substring(1), str);
            }
            String part = pattern.substring(1, nextIndex);
            int partIndex = str.indexOf(part);
            while (partIndex != -1) {
                if (Regex.simpleMatchWithNormalizedStrings(pattern.substring(nextIndex), str.substring(partIndex + part.length()))) {
                    return true;
                }
                partIndex = str.indexOf(part, partIndex + 1);
            }
            return false;
        }
        return str.regionMatches(0, pattern, 0, firstIndex) && (firstIndex == pattern.length() - 1 || Regex.simpleMatchWithNormalizedStrings(pattern.substring(firstIndex), str.substring(firstIndex)));
    }
}

