/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.concurrent;

import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.concurrent.AbstractFuture;
import cn.sliew.milky.concurrent.FailedFuture;
import cn.sliew.milky.concurrent.Future;
import cn.sliew.milky.concurrent.FutureListener;
import cn.sliew.milky.concurrent.Promise;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class DefaultPromise<V>
extends AbstractFuture<V>
implements Promise<V> {
    private static final AtomicReferenceFieldUpdater<DefaultPromise, Object> RESULT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultPromise.class, Object.class, "result");
    private static final Object SUCCESS = new Object();
    private static final Object UNCANCELLABLE = new Object();
    private static final CauseHolder CANCELLATION_CAUSE_HOLDER = new CauseHolder(DefaultPromise.unknownStackTrace(new CancellationException(), DefaultPromise.class, "cancel(...)"));
    private volatile Object result;
    protected List<FutureListener<? extends Future<? super V>>> listeners;
    private short waiters;
    private boolean notifying;

    @Override
    public Promise<V> setSuccess(V result) {
        if (this.setSuccess0(result)) {
            return this;
        }
        throw new IllegalStateException("complete already: " + this);
    }

    @Override
    public boolean trySuccess(V result) {
        return this.setSuccess0(result);
    }

    @Override
    public Promise<V> setFailure(Throwable cause) {
        if (this.setFailure0(cause)) {
            return this;
        }
        throw new IllegalStateException("complete already: " + this, cause);
    }

    @Override
    public boolean tryFailure(Throwable cause) {
        return this.setFailure0(cause);
    }

    private boolean setSuccess0(V result) {
        return this.setValue0(result == null ? SUCCESS : result);
    }

    private boolean setFailure0(Throwable cause) {
        return this.setValue0(new CauseHolder(Ensures.checkNotNull(cause, () -> "cause null")));
    }

    private boolean setValue0(Object objResult) {
        if (RESULT_UPDATER.compareAndSet(this, null, objResult) || RESULT_UPDATER.compareAndSet(this, UNCANCELLABLE, objResult)) {
            if (this.checkNotifyWaiters()) {
                this.notifyListeners();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> addListener(FutureListener<? extends Future<? super V>> listener) {
        Ensures.checkNotNull(listener, () -> "listener");
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            if (this.listeners == null) {
                this.listeners = new LinkedList<FutureListener<? extends Future<? super V>>>();
            }
            this.listeners.add(listener);
        }
        if (this.isDone()) {
            this.notifyListeners();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> removeListener(FutureListener<? extends Future<? super V>> listener) {
        Ensures.checkNotNull(listener, () -> "listener null");
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            this.listeners.remove(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        List<FutureListener<Future<V>>> listeners;
        Object object = this;
        synchronized (object) {
            if (this.notifying || this.listeners == null || this.listeners.isEmpty()) {
                return;
            }
            this.notifying = true;
            listeners = this.listeners;
            this.listeners = null;
        }
        while (true) {
            for (FutureListener futureListener : listeners) {
                DefaultPromise.notifyListener0(this, futureListener);
            }
            object = this;
            synchronized (object) {
                if (this.listeners == null) {
                    this.notifying = false;
                    return;
                }
                listeners = this.listeners;
                this.listeners = null;
            }
        }
    }

    private static void notifyListener0(Future future, FutureListener listener) {
        try {
            listener.onComplete(future);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public Promise<V> sync() throws InterruptedException {
        this.await();
        this.rethrowIfFailed();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> await() throws InterruptedException {
        if (this.isDone()) {
            return this;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException(this.toString());
        }
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            while (!this.isDone()) {
                this.incWaiters();
                try {
                    this.wait();
                }
                finally {
                    this.decWaiters();
                }
            }
        }
        return this;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.await0(unit.toNanos(timeout), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean await0(long timeoutNanos, boolean interruptable) throws InterruptedException {
        if (this.isDone()) {
            return true;
        }
        if (timeoutNanos <= 0L) {
            return this.isDone();
        }
        if (interruptable && Thread.interrupted()) {
            throw new InterruptedException(this.toString());
        }
        long startTime = System.nanoTime();
        long waitTime = timeoutNanos;
        boolean interrupted = false;
        try {
            do {
                DefaultPromise defaultPromise = this;
                synchronized (defaultPromise) {
                    block20: {
                        if (!this.isDone()) break block20;
                        boolean bl = true;
                        return bl;
                    }
                    this.incWaiters();
                    try {
                        this.wait(waitTime / 1000000L, (int)(waitTime % 1000000L));
                    }
                    catch (InterruptedException e) {
                        if (interruptable) {
                            throw e;
                        }
                        interrupted = true;
                    }
                    finally {
                        this.decWaiters();
                    }
                }
                if (!this.isDone()) continue;
                boolean bl = true;
                return bl;
            } while ((waitTime = timeoutNanos - (System.nanoTime() - startTime)) > 0L);
            boolean bl = this.isDone();
            return bl;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public boolean isSuccess() {
        Object result = this.result;
        return result != null && result != UNCANCELLABLE && !(result instanceof CauseHolder);
    }

    @Override
    public Throwable cause() {
        Object result = this.result;
        return result instanceof CauseHolder ? ((CauseHolder)result).cause : null;
    }

    @Override
    public V getNow() {
        Object result = this.result;
        if (result instanceof CauseHolder || result == SUCCESS || result == UNCANCELLABLE) {
            return null;
        }
        return (V)result;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (RESULT_UPDATER.compareAndSet(this, null, CANCELLATION_CAUSE_HOLDER)) {
            if (this.checkNotifyWaiters()) {
                this.notifyListeners();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this.result instanceof CauseHolder && ((CauseHolder)this.result).cause instanceof CancellationException;
    }

    @Override
    public boolean isDone() {
        return this.result != null && this.result != UNCANCELLABLE;
    }

    private synchronized boolean checkNotifyWaiters() {
        if (this.waiters > 0) {
            this.notifyAll();
        }
        return this.listeners != null;
    }

    private void incWaiters() {
        if (this.waiters == Short.MAX_VALUE) {
            throw new IllegalStateException("too many waiters: " + this);
        }
        this.waiters = (short)(this.waiters + 1);
    }

    private void decWaiters() {
        this.waiters = (short)(this.waiters - 1);
    }

    private static <T extends Throwable> T unknownStackTrace(T cause, Class<?> clazz, String method) {
        cause.setStackTrace(new StackTraceElement[]{new StackTraceElement(clazz.getName(), method, null, -1)});
        return cause;
    }

    private void rethrowIfFailed() {
        Throwable cause = this.cause();
        if (cause == null) {
            return;
        }
        FailedFuture.throwException0(cause);
    }

    private static final class CauseHolder {
        final Throwable cause;

        CauseHolder(Throwable cause) {
            this.cause = cause;
        }
    }
}

