/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.concurrent.threadpool;

import cn.sliew.milky.common.check.Ensures;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class DaemonThreadFactory
implements ThreadFactory {
    private final int threadPriority = 5;
    private final String threadNamePrefix;
    private final boolean daemon;
    private final ThreadGroup threadGroup;
    private final AtomicInteger threadCount = new AtomicInteger(0);

    DaemonThreadFactory(String threadNamePrefix, boolean daemon, ThreadGroup threadGroup) {
        this.threadNamePrefix = Ensures.checkNotNull(threadNamePrefix);
        this.daemon = daemon;
        SecurityManager s = System.getSecurityManager();
        this.threadGroup = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(this.threadGroup, runnable, this.nextThreadName());
        thread.setPriority(5);
        thread.setDaemon(this.daemon);
        return thread;
    }

    protected String nextThreadName() {
        return this.threadNamePrefix + this.threadCount.incrementAndGet();
    }
}

