/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.constant;

import cn.sliew.milky.common.constant.Constant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractConstant<T extends AbstractConstant<T>>
implements Constant<T> {
    private static final AtomicLong uniqueIdGenerator = new AtomicLong();
    private final int id;
    private final String name;
    private final long uniquifier;

    protected AbstractConstant(int id, String name) {
        this.id = id;
        this.name = name;
        this.uniquifier = uniqueIdGenerator.getAndIncrement();
    }

    @Override
    public final int id() {
        return this.id;
    }

    @Override
    public final String name() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractConstant that = (AbstractConstant)o;
        return this.id == that.id && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }

    public String toString() {
        return String.format("Constant{id=%s, name=%s}", this.id, this.name);
    }

    @Override
    public final int compareTo(T o) {
        if (this == o) {
            return 0;
        }
        T other = o;
        int returnCode = this.hashCode() - ((AbstractConstant)other).hashCode();
        if (returnCode != 0) {
            return returnCode;
        }
        if (this.uniquifier < ((AbstractConstant)other).uniquifier) {
            return -1;
        }
        if (this.uniquifier > ((AbstractConstant)other).uniquifier) {
            return 1;
        }
        throw new Error("failed to compare two different constants");
    }
}

