/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.sakura.catalog.service;

import cn.sliew.sakura.catalog.service.dto.CatalogDatabaseDTO;
import cn.sliew.sakura.catalog.service.dto.CatalogFunctionDTO;
import cn.sliew.sakura.catalog.service.dto.CatalogTableDTO;
import cn.sliew.sakura.common.dict.catalog.CatalogType;
import java.util.List;
import java.util.Optional;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;

public interface CatalogService {
    public List<CatalogDatabaseDTO> listDatabases(CatalogType var1, String var2);

    public Optional<CatalogDatabaseDTO> getDatabase(CatalogType var1, String var2, String var3);

    public boolean databaseExists(CatalogType var1, String var2, String var3);

    public void insertDatabase(CatalogDatabaseDTO var1) throws DatabaseAlreadyExistException;

    public void updateDatabase(CatalogDatabaseDTO var1) throws DatabaseNotExistException;

    public void deleteDatabase(CatalogType var1, String var2, String var3) throws DatabaseNotExistException;

    public boolean isDatabaseEmpty(CatalogType var1, String var2, String var3);

    public List<CatalogTableDTO> listTables(CatalogType var1, String var2, String var3);

    public Optional<CatalogTableDTO> getTable(CatalogType var1, String var2, String var3, String var4);

    public boolean tableExists(CatalogType var1, String var2, String var3, String var4);

    public void insertTable(CatalogType var1, String var2, String var3, CatalogTableDTO var4) throws DatabaseNotExistException, TableAlreadyExistException;

    public void updateTable(CatalogType var1, String var2, String var3, CatalogTableDTO var4) throws TableNotExistException;

    public void renameTable(CatalogType var1, String var2, String var3, String var4, String var5) throws TableAlreadyExistException, TableNotExistException;

    public void deleteTable(CatalogType var1, String var2, String var3, String var4) throws TableNotExistException;

    public List<CatalogTableDTO> listViews(CatalogType var1, String var2, String var3);

    public Optional<CatalogTableDTO> getView(CatalogType var1, String var2, String var3, String var4);

    public boolean viewExists(CatalogType var1, String var2, String var3, String var4);

    public void insertView(CatalogType var1, String var2, String var3, CatalogTableDTO var4) throws DatabaseNotExistException, TableAlreadyExistException;

    public void updateView(CatalogType var1, String var2, String var3, CatalogTableDTO var4) throws TableNotExistException;

    public void renameView(CatalogType var1, String var2, String var3, String var4, String var5) throws TableNotExistException, TableAlreadyExistException;

    public void deleteView(CatalogType var1, String var2, String var3, String var4) throws TableNotExistException;

    public List<CatalogFunctionDTO> listFunctions(CatalogType var1, String var2, String var3);

    public Optional<CatalogFunctionDTO> getFunction(CatalogType var1, String var2, String var3, String var4);

    public boolean functionExists(CatalogType var1, String var2, String var3, String var4);

    public void insertFunction(CatalogType var1, String var2, String var3, CatalogFunctionDTO var4) throws DatabaseNotExistException, FunctionAlreadyExistException;

    public void updateFunction(CatalogType var1, String var2, String var3, CatalogFunctionDTO var4) throws FunctionNotExistException;

    public void deleteFunction(CatalogType var1, String var2, String var3, String var4) throws FunctionNotExistException;
}

