/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.sakura.catalog.service.convert;

import cn.sliew.milky.common.util.JacksonUtil;
import cn.sliew.sakura.catalog.service.convert.BaseConvert;
import cn.sliew.sakura.catalog.service.convert.Util;
import cn.sliew.sakura.catalog.service.dto.CatalogStoreDTO;
import cn.sliew.sakura.common.exception.Rethrower;
import cn.sliew.sakura.common.util.CodecUtil;
import cn.sliew.sakura.dao.entity.CatalogStore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.Configuration;

public enum CatalogStoreConvert implements BaseConvert<CatalogStore, CatalogStoreDTO>
{
    INSTANCE;


    @Override
    public CatalogStore toDo(CatalogStoreDTO dto) {
        try {
            CatalogStore entity = new CatalogStore();
            Util.copyProperties(dto, entity);
            entity.setCatalogName(dto.getCatalogName());
            if (dto.getConfiguration() != null) {
                entity.setConfiguration(CodecUtil.decrypt(JacksonUtil.toJsonString(dto.getConfiguration())));
            }
            return entity;
        }
        catch (Exception e) {
            Rethrower.throwAs(e);
            return null;
        }
    }

    @Override
    public CatalogStoreDTO toDto(CatalogStore entity) {
        try {
            CatalogStoreDTO dto = new CatalogStoreDTO();
            Util.copyProperties(entity, dto);
            dto.setCatalogName(entity.getCatalogName());
            if (entity != null && StringUtils.isNotBlank((CharSequence)entity.getConfiguration())) {
                Map<String, String> configuration = JacksonUtil.parseJsonString(CodecUtil.decrypt(entity.getConfiguration()), new TypeReference<Map<String, String>>(){});
                dto.setConfiguration(Configuration.fromMap(configuration));
            }
            return dto;
        }
        catch (Exception e) {
            Rethrower.throwAs(e);
            return null;
        }
    }
}

