/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.sakura.catalog.store;

import cn.sliew.sakura.catalog.service.CatalogStoreService;
import cn.sliew.sakura.catalog.service.dto.CatalogStoreDTO;
import cn.sliew.sakura.catalog.service.impl.CatalogStoreServiceImpl;
import cn.sliew.sakura.common.dict.catalog.CatalogType;
import cn.sliew.sakura.dao.util.MybatisUtil;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.catalog.AbstractCatalogStore;
import org.apache.flink.table.catalog.CatalogDescriptor;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.ibatis.session.SqlSessionFactory;

public class JdbcCatalogStore
extends AbstractCatalogStore {
    private final String driver;
    private final String jdbcUrl;
    private final String username;
    private final String password;
    private HikariDataSource dataSource;
    private CatalogStoreService catalogStoreService;

    public JdbcCatalogStore(String driver, String jdbcUrl, String username, String password) {
        this.driver = driver;
        this.jdbcUrl = jdbcUrl;
        this.username = username;
        this.password = password;
    }

    public void open() {
        super.open();
        this.dataSource = MybatisUtil.createDataSource(this.driver, this.jdbcUrl, this.username, this.password);
        SqlSessionFactory sqlSessionFactory = MybatisUtil.getSqlSessionFactory((DataSource)this.dataSource);
        this.catalogStoreService = new CatalogStoreServiceImpl(sqlSessionFactory);
    }

    public void close() {
        super.close();
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
        }
    }

    public void storeCatalog(String catalogName, CatalogDescriptor catalog) throws CatalogException {
        if (this.contains(catalogName)) {
            throw new CatalogException(String.format("Catalog %s's store is already exist.", catalogName));
        }
        CatalogStoreDTO dto = new CatalogStoreDTO();
        dto.setType(CatalogType.FLINK);
        dto.setCatalogName(catalog.getCatalogName());
        dto.setConfiguration(catalog.getConfiguration());
        this.catalogStoreService.insert(dto);
    }

    public void removeCatalog(String catalogName, boolean ignoreIfNotExists) throws CatalogException {
        if (!this.contains(catalogName) && !ignoreIfNotExists) {
            throw new CatalogException(String.format("Catalog %s's store is not exist", catalogName));
        }
        this.catalogStoreService.delete(CatalogType.FLINK, catalogName);
    }

    public Optional<CatalogDescriptor> getCatalog(String catalogName) throws CatalogException {
        return this.catalogStoreService.get(CatalogType.FLINK, catalogName).map(dto -> CatalogDescriptor.of((String)dto.getCatalogName(), (Configuration)dto.getConfiguration()));
    }

    public Set<String> listCatalogs() throws CatalogException {
        return this.catalogStoreService.list(CatalogType.FLINK).stream().map(CatalogStoreDTO::getCatalogName).collect(Collectors.toSet());
    }

    public boolean contains(String catalogName) throws CatalogException {
        return this.getCatalog(catalogName).isPresent();
    }
}

