/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.sakura.common.exception;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.function.Function;

public enum Rethrower {


    public static void rethrowIfUnrecoverable(Throwable exception) {
        if (exception instanceof OutOfMemoryError) {
            Rethrower.throwAsUncheckedException(exception);
        }
    }

    public static RuntimeException throwAsUncheckedException(Throwable t) {
        Preconditions.checkNotNull((Object)t, (Object)"Throwable must not be null");
        Rethrower.throwAs(t);
        return null;
    }

    public static <T extends Throwable> void throwAs(Throwable t) throws T {
        throw t;
    }

    public static <T> T toRuntime(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void toRuntime(Procedure voidCallable) {
        Rethrower.castCheckedToRuntime(voidCallable, RuntimeException::new);
    }

    public static void toIllegalState(Procedure voidCallable) {
        Rethrower.castCheckedToRuntime(voidCallable, IllegalStateException::new);
    }

    public static void toIllegalArgument(Procedure voidCallable) {
        Rethrower.castCheckedToRuntime(voidCallable, IllegalArgumentException::new);
    }

    private static void castCheckedToRuntime(Procedure voidCallable, Function<Exception, RuntimeException> exceptionFactory) {
        try {
            voidCallable.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw exceptionFactory.apply(e);
        }
    }

    public static void swallow(Procedure procedure) {
        try {
            procedure.call();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface Procedure {
        public void call() throws Exception;
    }
}

