/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.unit;

import cn.sliew.milky.common.primitives.Strings;
import cn.sliew.milky.common.unit.ByteUnit;
import cn.sliew.milky.common.unit.ValueParseException;
import java.util.Locale;

public class ByteValue
implements Comparable<ByteValue> {
    public static final ByteValue ZERO = new ByteValue(0L, ByteUnit.BYTES);
    private final Long size;
    private final ByteUnit unit;

    public ByteValue(long bytes) {
        this(bytes, ByteUnit.BYTES);
    }

    public ByteValue(long size, ByteUnit unit) {
        this.size = size;
        this.unit = unit;
    }

    public long getBytes() {
        return this.unit.toBytes(this.size);
    }

    public long getKb() {
        return this.unit.toKB(this.size);
    }

    public long getMb() {
        return this.unit.toMB(this.size);
    }

    public long getGb() {
        return this.unit.toGB(this.size);
    }

    public long getTb() {
        return this.unit.toTB(this.size);
    }

    public long getPb() {
        return this.unit.toPB(this.size);
    }

    public double getKbFrac() {
        return (double)this.getBytes() / 1024.0;
    }

    public double getMbFrac() {
        return (double)this.getBytes() / 1048576.0;
    }

    public double getGbFrac() {
        return (double)this.getBytes() / 1.073741824E9;
    }

    public double getTbFrac() {
        return (double)this.getBytes() / 1.099511627776E12;
    }

    public double getPbFrac() {
        return (double)this.getBytes() / 1.125899906842624E15;
    }

    public static ByteValue parseByteValue(String value) throws ValueParseException {
        return ByteValue.parseByteValue(value, null);
    }

    public static ByteValue parseByteValue(String value, ByteValue defaultValue) throws ValueParseException {
        if (value == null) {
            return defaultValue;
        }
        String lowerValue = value.toLowerCase(Locale.ROOT).trim();
        if (lowerValue.endsWith("k")) {
            return ByteValue.parse(value, lowerValue, "k", ByteUnit.KB);
        }
        if (lowerValue.endsWith("kb")) {
            return ByteValue.parse(value, lowerValue, "kb", ByteUnit.KB);
        }
        if (lowerValue.endsWith("m")) {
            return ByteValue.parse(value, lowerValue, "m", ByteUnit.MB);
        }
        if (lowerValue.endsWith("mb")) {
            return ByteValue.parse(value, lowerValue, "mb", ByteUnit.MB);
        }
        if (lowerValue.endsWith("g")) {
            return ByteValue.parse(value, lowerValue, "g", ByteUnit.GB);
        }
        if (lowerValue.endsWith("gb")) {
            return ByteValue.parse(value, lowerValue, "gb", ByteUnit.GB);
        }
        if (lowerValue.endsWith("t")) {
            return ByteValue.parse(value, lowerValue, "t", ByteUnit.TB);
        }
        if (lowerValue.endsWith("tb")) {
            return ByteValue.parse(value, lowerValue, "tb", ByteUnit.TB);
        }
        if (lowerValue.endsWith("p")) {
            return ByteValue.parse(value, lowerValue, "p", ByteUnit.PB);
        }
        if (lowerValue.endsWith("pb")) {
            return ByteValue.parse(value, lowerValue, "pb", ByteUnit.PB);
        }
        if (lowerValue.endsWith("b")) {
            return new ByteValue(Long.parseLong(lowerValue.substring(0, lowerValue.length() - 1).trim()), ByteUnit.BYTES);
        }
        if (lowerValue.equals("-1")) {
            return new ByteValue(-1L, ByteUnit.BYTES);
        }
        if (lowerValue.equals("0")) {
            return new ByteValue(0L, ByteUnit.BYTES);
        }
        throw new ValueParseException(String.format("failed to parse value [{}] as a size in bytes: unit is missing or unrecognized", value));
    }

    private static ByteValue parse(String initialInput, String normalized, String suffix, ByteUnit unit) {
        String s = normalized.substring(0, normalized.length() - suffix.length()).trim();
        try {
            return new ByteValue(Long.parseLong(s), unit);
        }
        catch (NumberFormatException e) {
            throw new ValueParseException(String.format("failed to parse value [{}] as a size in bytes", initialInput), e);
        }
    }

    @Override
    public int compareTo(ByteValue other) {
        long thisValue = this.size * this.unit.toBytes(1L);
        long otherValue = other.size * other.unit.toBytes(1L);
        return Long.compare(thisValue, otherValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((ByteValue)o) == 0;
    }

    public int hashCode() {
        return Long.hashCode(this.size * this.unit.toBytes(1L));
    }

    public String toString() {
        long bytes = this.getBytes();
        double value = bytes;
        String suffix = ByteUnit.BYTES.getSuffix();
        if (bytes >= 0x4000000000000L) {
            value = this.getPbFrac();
            suffix = ByteUnit.PB.getSuffix();
        } else if (bytes >= 0x10000000000L) {
            value = this.getTbFrac();
            suffix = ByteUnit.TB.getSuffix();
        } else if (bytes >= 0x40000000L) {
            value = this.getGbFrac();
            suffix = ByteUnit.GB.getSuffix();
        } else if (bytes >= 0x100000L) {
            value = this.getMbFrac();
            suffix = ByteUnit.MB.getSuffix();
        } else if (bytes >= 1024L) {
            value = this.getKbFrac();
            suffix = ByteUnit.KB.getSuffix();
        }
        return Strings.format1Decimals(value, suffix);
    }
}

