/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.sakura.catalog.service.impl;

import cn.sliew.sakura.catalog.service.CatalogStoreService;
import cn.sliew.sakura.catalog.service.convert.CatalogStoreConvert;
import cn.sliew.sakura.catalog.service.dto.CatalogStoreDTO;
import cn.sliew.sakura.common.dict.catalog.CatalogType;
import cn.sliew.sakura.dao.entity.BaseDO;
import cn.sliew.sakura.dao.entity.CatalogStore;
import cn.sliew.sakura.dao.mapper.CatalogStoreMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public class CatalogStoreServiceImpl
implements CatalogStoreService {
    private final SqlSessionFactory sqlSessionFactory;

    public CatalogStoreServiceImpl(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    @Override
    public List<CatalogStoreDTO> list(CatalogType type) {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogStoreMapper catalogStoreMapper = (CatalogStoreMapper)sqlSession.getMapper(CatalogStoreMapper.class);
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CatalogStore.class).eq(CatalogStore::getType, (Object)type)).isNull(BaseDO::getDeleteTime)).orderByAsc(CatalogStore::getCatalogName);
            List catalogs = catalogStoreMapper.selectList((Wrapper)queryWrapper);
            List<CatalogStoreDTO> list = CatalogStoreConvert.INSTANCE.toDto(catalogs);
            return list;
        }
    }

    @Override
    public Optional<CatalogStoreDTO> get(CatalogType type, String catalogName) {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogStoreMapper catalogStoreMapper = (CatalogStoreMapper)sqlSession.getMapper(CatalogStoreMapper.class);
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CatalogStore.class).eq(CatalogStore::getType, (Object)type)).eq(CatalogStore::getCatalogName, (Object)catalogName)).isNull(BaseDO::getDeleteTime);
            CatalogStore catalog = (CatalogStore)catalogStoreMapper.selectOne((Wrapper)queryWrapper);
            Optional<CatalogStoreDTO> optional = Optional.ofNullable(catalog).map(CatalogStoreConvert.INSTANCE::toDto);
            return optional;
        }
    }

    @Override
    public void insert(CatalogStoreDTO dto) {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogStoreMapper catalogStoreMapper = (CatalogStoreMapper)sqlSession.getMapper(CatalogStoreMapper.class);
            CatalogStore record = CatalogStoreConvert.INSTANCE.toDo(dto);
            catalogStoreMapper.insert(record);
            sqlSession.commit();
        }
    }

    @Override
    public void delete(CatalogType type, String catalogName) {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogStoreMapper catalogStoreMapper = (CatalogStoreMapper)sqlSession.getMapper(CatalogStoreMapper.class);
            LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(CatalogStore.class).eq(CatalogStore::getType, (Object)type)).eq(CatalogStore::getCatalogName, (Object)catalogName)).isNull(BaseDO::getDeleteTime);
            CatalogStore record = new CatalogStore();
            record.setType(type);
            record.setCatalogName(catalogName);
            record.setDeleteTime(new Date());
            catalogStoreMapper.update(record, (Wrapper)updateWrapper);
            sqlSession.commit();
        }
    }
}

