/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.sakura.catalog.store;

import cn.sliew.sakura.catalog.store.JdbcCatalogStore;
import cn.sliew.sakura.catalog.store.JdbcCatalogStoreOptions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.CatalogStore;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.factories.CatalogStoreFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;

public class JdbcCatalogStoreFactory
implements CatalogStoreFactory {
    private String driver;
    private String jdbcUrl;
    private String username;
    private String password;

    public CatalogStore createCatalogStore() {
        return new JdbcCatalogStore(this.driver, this.jdbcUrl, this.username, this.password);
    }

    public void open(CatalogStoreFactory.Context context) throws CatalogException {
        CatalogStoreFactoryHelper factoryHelper = new CatalogStoreFactoryHelper(this, context);
        factoryHelper.validate();
        ReadableConfig options = factoryHelper.getOptions();
        this.driver = (String)options.get(JdbcCatalogStoreOptions.DRIVER);
        this.jdbcUrl = (String)options.get(JdbcCatalogStoreOptions.JDBC_URL);
        this.username = (String)options.get(JdbcCatalogStoreOptions.USERNAME);
        this.password = (String)options.get(JdbcCatalogStoreOptions.PASSWORD);
    }

    public void close() throws CatalogException {
    }

    public String factoryIdentifier() {
        return "jdbc";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(JdbcCatalogStoreOptions.DRIVER);
        options.add(JdbcCatalogStoreOptions.JDBC_URL);
        options.add(JdbcCatalogStoreOptions.USERNAME);
        options.add(JdbcCatalogStoreOptions.PASSWORD);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Collections.emptySet();
    }

    public static class CatalogStoreFactoryHelper
    extends FactoryUtil.FactoryHelper<CatalogStoreFactory> {
        public CatalogStoreFactoryHelper(CatalogStoreFactory catalogStoreFactory, CatalogStoreFactory.Context context) {
            super((Factory)catalogStoreFactory, context.getOptions(), new ConfigOption[]{FactoryUtil.PROPERTY_VERSION});
        }
    }
}

