/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.sakura.catalog.factory;

import cn.sliew.sakura.catalog.SakuraCatalogView;
import cn.sliew.sakura.catalog.factory.CatalogSchemaFactory;
import cn.sliew.sakura.catalog.service.dto.CatalogTableDTO;
import cn.sliew.sakura.common.dict.CatalogTableKind;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogView;

public enum CatalogViewFactory {


    public static CatalogTableDTO fromResolvedView(String viewName, ResolvedCatalogView resolvedView) {
        CatalogTableDTO catalogView = new CatalogTableDTO();
        catalogView.setKind(CatalogTableKind.VIEW);
        catalogView.setName(viewName);
        catalogView.setSchema(CatalogSchemaFactory.toSchema(resolvedView.getResolvedSchema()));
        catalogView.setProperties(resolvedView.getOptions());
        catalogView.setOriginalQuery(resolvedView.getOriginalQuery());
        catalogView.setExpandedQuery(resolvedView.getExpandedQuery());
        catalogView.setRemark(resolvedView.getComment());
        return catalogView;
    }

    public static CatalogTableDTO fromUnresolvedTable(String viewName, CatalogBaseTable catalogBaseTable) {
        CatalogTableDTO catalogView = new CatalogTableDTO();
        catalogView.setKind(CatalogTableKind.VIEW);
        catalogView.setName(viewName);
        catalogView.setSchema(CatalogSchemaFactory.toSchema(catalogBaseTable.getUnresolvedSchema()));
        catalogView.setProperties(catalogBaseTable.getOptions());
        catalogView.setOriginalQuery(catalogView.getOriginalQuery());
        catalogView.setExpandedQuery(catalogView.getExpandedQuery());
        catalogView.setRemark(catalogBaseTable.getComment());
        return catalogView;
    }

    public static SakuraCatalogView toView(CatalogTableDTO catalogTableDTO) {
        Schema schema = CatalogSchemaFactory.toCatalog(catalogTableDTO.getSchema());
        return new SakuraCatalogView(schema, catalogTableDTO.getProperties(), catalogTableDTO.getRemark(), catalogTableDTO.getOriginalQuery(), catalogTableDTO.getExpandedQuery());
    }
}

