/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.sakura.catalog.service;

import cn.sliew.sakura.catalog.service.dto.CatalogDatabaseDTO;
import cn.sliew.sakura.catalog.service.dto.CatalogFunctionDTO;
import cn.sliew.sakura.catalog.service.dto.CatalogTableDTO;
import java.util.List;
import java.util.Optional;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;

public interface CatalogService {
    public List<CatalogDatabaseDTO> listDatabases(String var1);

    public Optional<CatalogDatabaseDTO> getDatabase(String var1, String var2);

    public boolean databaseExists(String var1, String var2);

    public void insertDatabase(CatalogDatabaseDTO var1) throws DatabaseAlreadyExistException;

    public void updateDatabase(CatalogDatabaseDTO var1) throws DatabaseNotExistException;

    public void deleteDatabase(String var1, String var2) throws DatabaseNotExistException;

    public boolean isDatabaseEmpty(String var1, String var2);

    public List<CatalogTableDTO> listTables(String var1, String var2);

    public Optional<CatalogTableDTO> getTable(String var1, String var2, String var3);

    public boolean tableExists(String var1, String var2, String var3);

    public void insertTable(String var1, String var2, CatalogTableDTO var3) throws DatabaseNotExistException, TableAlreadyExistException;

    public void updateTable(String var1, String var2, CatalogTableDTO var3) throws TableNotExistException;

    public void renameTable(String var1, String var2, String var3, String var4) throws TableAlreadyExistException, TableNotExistException;

    public void deleteTable(String var1, String var2, String var3) throws TableNotExistException;

    public List<CatalogTableDTO> listViews(String var1, String var2);

    public Optional<CatalogTableDTO> getView(String var1, String var2, String var3);

    public boolean viewExists(String var1, String var2, String var3);

    public void insertView(String var1, String var2, CatalogTableDTO var3) throws DatabaseNotExistException, TableAlreadyExistException;

    public void updateView(String var1, String var2, CatalogTableDTO var3) throws TableNotExistException;

    public void renameView(String var1, String var2, String var3, String var4) throws TableNotExistException, TableAlreadyExistException;

    public void deleteView(String var1, String var2, String var3) throws TableNotExistException;

    public List<CatalogFunctionDTO> listFunctions(String var1, String var2);

    public Optional<CatalogFunctionDTO> getFunction(String var1, String var2, String var3);

    public boolean functionExists(String var1, String var2, String var3);

    public void insertFunction(String var1, String var2, CatalogFunctionDTO var3) throws DatabaseNotExistException, FunctionAlreadyExistException;

    public void updateFunction(String var1, String var2, CatalogFunctionDTO var3) throws FunctionNotExistException;

    public void deleteFunction(String var1, String var2, String var3) throws FunctionNotExistException;
}

