/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.sakura.catalog.service.impl;

import cn.sliew.sakura.catalog.service.CatalogService;
import cn.sliew.sakura.catalog.service.convert.CatalogDatabaseConvert;
import cn.sliew.sakura.catalog.service.convert.CatalogFunctionConvert;
import cn.sliew.sakura.catalog.service.convert.CatalogTableConvert;
import cn.sliew.sakura.catalog.service.dto.CatalogDatabaseDTO;
import cn.sliew.sakura.catalog.service.dto.CatalogFunctionDTO;
import cn.sliew.sakura.catalog.service.dto.CatalogTableDTO;
import cn.sliew.sakura.common.dict.CatalogTableKind;
import cn.sliew.sakura.dao.entity.CatalogDatabase;
import cn.sliew.sakura.dao.entity.CatalogFunction;
import cn.sliew.sakura.dao.entity.CatalogTable;
import cn.sliew.sakura.dao.mapper.CatalogDatabaseMapper;
import cn.sliew.sakura.dao.mapper.CatalogFunctionMapper;
import cn.sliew.sakura.dao.mapper.CatalogTableMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.List;
import java.util.Optional;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public class CatalogServiceImpl
implements CatalogService {
    private final SqlSessionFactory sqlSessionFactory;

    public CatalogServiceImpl(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    @Override
    public List<CatalogDatabaseDTO> listDatabases(String catalog) {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogDatabaseMapper catalogDatabaseMapper = (CatalogDatabaseMapper)sqlSession.getMapper(CatalogDatabaseMapper.class);
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CatalogDatabase.class).eq(CatalogDatabase::getCatalog, (Object)catalog)).orderByAsc(CatalogDatabase::getName);
            List databases = catalogDatabaseMapper.selectList((Wrapper)queryWrapper);
            List<CatalogDatabaseDTO> list = CatalogDatabaseConvert.INSTANCE.toDto(databases);
            return list;
        }
    }

    @Override
    public Optional<CatalogDatabaseDTO> getDatabase(String catalog, String database) {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogDatabaseMapper catalogDatabaseMapper = (CatalogDatabaseMapper)sqlSession.getMapper(CatalogDatabaseMapper.class);
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CatalogDatabase.class).eq(CatalogDatabase::getCatalog, (Object)catalog)).eq(CatalogDatabase::getName, (Object)database);
            CatalogDatabase record = (CatalogDatabase)catalogDatabaseMapper.selectOne((Wrapper)queryWrapper);
            if (record == null) {
                Optional<CatalogDatabaseDTO> optional = Optional.empty();
                return optional;
            }
            Optional<CatalogDatabaseDTO> optional = Optional.of(CatalogDatabaseConvert.INSTANCE.toDto(record));
            return optional;
        }
    }

    @Override
    public boolean databaseExists(String catalog, String database) {
        Optional<CatalogDatabaseDTO> optional = this.getDatabase(catalog, database);
        return optional.isPresent();
    }

    @Override
    public void insertDatabase(CatalogDatabaseDTO database) throws DatabaseAlreadyExistException {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogDatabaseMapper catalogDatabaseMapper = (CatalogDatabaseMapper)sqlSession.getMapper(CatalogDatabaseMapper.class);
            if (this.databaseExists(database.getCatalog(), database.getName())) {
                throw new DatabaseAlreadyExistException(database.getCatalog(), database.getName());
            }
            CatalogDatabase record = CatalogDatabaseConvert.INSTANCE.toDo(database);
            catalogDatabaseMapper.insert(record);
            sqlSession.commit();
        }
    }

    @Override
    public void updateDatabase(CatalogDatabaseDTO database) throws DatabaseNotExistException {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogDatabaseMapper catalogDatabaseMapper = (CatalogDatabaseMapper)sqlSession.getMapper(CatalogDatabaseMapper.class);
            if (!this.databaseExists(database.getCatalog(), database.getName())) {
                throw new DatabaseNotExistException(database.getCatalog(), database.getName());
            }
            CatalogDatabase record = CatalogDatabaseConvert.INSTANCE.toDo(database);
            catalogDatabaseMapper.updateById(record);
            sqlSession.commit();
        }
    }

    @Override
    public void deleteDatabase(String catalog, String database) throws DatabaseNotExistException {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogDatabaseMapper catalogDatabaseMapper = (CatalogDatabaseMapper)sqlSession.getMapper(CatalogDatabaseMapper.class);
            if (!this.databaseExists(catalog, database)) {
                throw new DatabaseNotExistException(catalog, database);
            }
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CatalogDatabase.class).eq(CatalogDatabase::getCatalog, (Object)catalog)).eq(CatalogDatabase::getName, (Object)database);
            catalogDatabaseMapper.delete((Wrapper)queryWrapper);
            sqlSession.commit();
        }
    }

    @Override
    public boolean isDatabaseEmpty(String catalog, String database) {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogTableMapper catalogTableMapper = (CatalogTableMapper)sqlSession.getMapper(CatalogTableMapper.class);
            CatalogFunctionMapper catalogFunctionMapper = (CatalogFunctionMapper)sqlSession.getMapper(CatalogFunctionMapper.class);
            int tableCount = catalogTableMapper.countByDatabase(catalog, database, CatalogTableKind.TABLE);
            int functionCount = catalogFunctionMapper.countByDatabase(catalog, database);
            boolean bl = tableCount != 0 || functionCount != 0;
            return bl;
        }
    }

    @Override
    public List<CatalogTableDTO> listTables(String catalog, String database) {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogTableMapper catalogTableMapper = (CatalogTableMapper)sqlSession.getMapper(CatalogTableMapper.class);
            List<CatalogTable> records = catalogTableMapper.selectByDatabase(catalog, database, CatalogTableKind.TABLE);
            List<CatalogTableDTO> list = CatalogTableConvert.INSTANCE.toDto(records);
            return list;
        }
    }

    @Override
    public Optional<CatalogTableDTO> getTable(String catalog, String database, String table) {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogTableMapper catalogTableMapper = (CatalogTableMapper)sqlSession.getMapper(CatalogTableMapper.class);
            Optional<CatalogTable> optional = catalogTableMapper.selectByName(catalog, database, CatalogTableKind.TABLE, table);
            Optional<CatalogTableDTO> optional2 = optional.map(record -> CatalogTableConvert.INSTANCE.toDto((CatalogTable)record));
            return optional2;
        }
    }

    @Override
    public boolean tableExists(String catalog, String database, String table) {
        Optional<CatalogTableDTO> optional = this.getTable(catalog, database, table);
        return optional.isPresent();
    }

    @Override
    public void insertTable(String catalog, String database, CatalogTableDTO table) throws DatabaseNotExistException, TableAlreadyExistException {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogTableMapper catalogTableMapper = (CatalogTableMapper)sqlSession.getMapper(CatalogTableMapper.class);
            CatalogDatabaseDTO catalogDatabaseDTO = this.getDatabase(catalog, database).orElseThrow(() -> new DatabaseNotExistException(catalog, database));
            if (this.tableExists(catalog, database, table.getName())) {
                throw new TableAlreadyExistException(catalog, new ObjectPath(database, table.getName()));
            }
            CatalogTable record = CatalogTableConvert.INSTANCE.toDo(table);
            record.setDatabaseId(catalogDatabaseDTO.getId());
            catalogTableMapper.insert(record);
            sqlSession.commit();
        }
    }

    @Override
    public void updateTable(String catalog, String database, CatalogTableDTO table) throws TableNotExistException {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogTableMapper catalogTableMapper = (CatalogTableMapper)sqlSession.getMapper(CatalogTableMapper.class);
            if (!this.tableExists(catalog, database, table.getName())) {
                throw new TableNotExistException(catalog, new ObjectPath(database, table.getName()));
            }
            CatalogTable record = CatalogTableConvert.INSTANCE.toDo(table);
            catalogTableMapper.updateById(record);
            sqlSession.commit();
        }
    }

    @Override
    public void renameTable(String catalog, String database, String currentName, String newName) throws TableAlreadyExistException, TableNotExistException {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogTableMapper catalogTableMapper = (CatalogTableMapper)sqlSession.getMapper(CatalogTableMapper.class);
            CatalogTableDTO catalogTableDTO = this.getTable(catalog, database, currentName).orElseThrow(() -> new TableNotExistException(catalog, new ObjectPath(database, currentName)));
            if (this.tableExists(catalog, database, newName)) {
                throw new TableAlreadyExistException(catalog, new ObjectPath(database, newName));
            }
            CatalogTable record = CatalogTableConvert.INSTANCE.toDo(catalogTableDTO);
            record.setName(newName);
            catalogTableMapper.updateById(record);
            sqlSession.commit();
        }
    }

    @Override
    public void deleteTable(String catalog, String database, String table) throws TableNotExistException {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogTableMapper catalogTableMapper = (CatalogTableMapper)sqlSession.getMapper(CatalogTableMapper.class);
            CatalogTableDTO catalogTableDTO = this.getTable(catalog, database, table).orElseThrow(() -> new TableNotExistException(catalog, new ObjectPath(database, table)));
            CatalogTable record = CatalogTableConvert.INSTANCE.toDo(catalogTableDTO);
            catalogTableMapper.deleteById(record.getId());
            sqlSession.commit();
        }
    }

    @Override
    public List<CatalogTableDTO> listViews(String catalog, String database) {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogTableMapper catalogTableMapper = (CatalogTableMapper)sqlSession.getMapper(CatalogTableMapper.class);
            List<CatalogTable> views = catalogTableMapper.selectByDatabase(catalog, database, CatalogTableKind.VIEW);
            List<CatalogTableDTO> list = CatalogTableConvert.INSTANCE.toDto(views);
            return list;
        }
    }

    @Override
    public Optional<CatalogTableDTO> getView(String catalog, String database, String view) {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogTableMapper catalogTableMapper = (CatalogTableMapper)sqlSession.getMapper(CatalogTableMapper.class);
            Optional<CatalogTable> optional = catalogTableMapper.selectByName(catalog, database, CatalogTableKind.VIEW, view);
            Optional<CatalogTableDTO> optional2 = optional.map(record -> CatalogTableConvert.INSTANCE.toDto((CatalogTable)record));
            return optional2;
        }
    }

    @Override
    public boolean viewExists(String catalog, String database, String view) {
        Optional<CatalogTableDTO> optional = this.getView(catalog, database, view);
        return optional.isPresent();
    }

    @Override
    public void insertView(String catalog, String database, CatalogTableDTO view) throws DatabaseNotExistException, TableAlreadyExistException {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogTableMapper catalogTableMapper = (CatalogTableMapper)sqlSession.getMapper(CatalogTableMapper.class);
            CatalogDatabaseDTO catalogDatabaseDTO = this.getDatabase(catalog, database).orElseThrow(() -> new DatabaseNotExistException(catalog, database));
            if (this.viewExists(catalog, database, view.getName())) {
                throw new TableAlreadyExistException(catalog, new ObjectPath(database, view.getName()));
            }
            CatalogTable record = CatalogTableConvert.INSTANCE.toDo(view);
            record.setDatabaseId(catalogDatabaseDTO.getId());
            catalogTableMapper.insert(record);
            sqlSession.commit();
        }
    }

    @Override
    public void updateView(String catalog, String database, CatalogTableDTO view) throws TableNotExistException {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogTableMapper catalogTableMapper = (CatalogTableMapper)sqlSession.getMapper(CatalogTableMapper.class);
            if (!this.viewExists(catalog, database, view.getName())) {
                throw new TableNotExistException(catalog, new ObjectPath(database, view.getName()));
            }
            CatalogTable record = CatalogTableConvert.INSTANCE.toDo(view);
            catalogTableMapper.updateById(record);
            sqlSession.commit();
        }
    }

    @Override
    public void renameView(String catalog, String database, String currentName, String newName) throws TableNotExistException, TableAlreadyExistException {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogTableMapper catalogTableMapper = (CatalogTableMapper)sqlSession.getMapper(CatalogTableMapper.class);
            CatalogTableDTO catalogViewDTO = this.getView(catalog, database, currentName).orElseThrow(() -> new TableNotExistException(catalog, new ObjectPath(database, currentName)));
            if (this.viewExists(catalog, database, newName)) {
                throw new TableAlreadyExistException(catalog, new ObjectPath(database, newName));
            }
            CatalogTable record = CatalogTableConvert.INSTANCE.toDo(catalogViewDTO);
            record.setName(newName);
            catalogTableMapper.updateById(record);
            sqlSession.commit();
        }
    }

    @Override
    public void deleteView(String catalog, String database, String viewName) throws TableNotExistException {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogTableMapper catalogTableMapper = (CatalogTableMapper)sqlSession.getMapper(CatalogTableMapper.class);
            CatalogTableDTO catalogViewDTO = this.getView(catalog, database, viewName).orElseThrow(() -> new TableNotExistException(catalog, new ObjectPath(database, viewName)));
            CatalogTable record = CatalogTableConvert.INSTANCE.toDo(catalogViewDTO);
            catalogTableMapper.deleteById(record.getId());
            sqlSession.commit();
        }
    }

    @Override
    public List<CatalogFunctionDTO> listFunctions(String catalog, String database) {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogFunctionMapper catalogFunctionMapper = (CatalogFunctionMapper)sqlSession.getMapper(CatalogFunctionMapper.class);
            List<CatalogFunction> catalogFunctions = catalogFunctionMapper.selectByDatabase(catalog, database);
            List<CatalogFunctionDTO> list = CatalogFunctionConvert.INSTANCE.toDto(catalogFunctions);
            return list;
        }
    }

    @Override
    public Optional<CatalogFunctionDTO> getFunction(String catalog, String database, String function) {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogFunctionMapper catalogFunctionMapper = (CatalogFunctionMapper)sqlSession.getMapper(CatalogFunctionMapper.class);
            Optional<CatalogFunction> optional = catalogFunctionMapper.selectByName(catalog, database, function);
            Optional<CatalogFunctionDTO> optional2 = optional.map(record -> CatalogFunctionConvert.INSTANCE.toDto((CatalogFunction)record));
            return optional2;
        }
    }

    @Override
    public boolean functionExists(String catalog, String database, String function) {
        Optional<CatalogFunctionDTO> optional = this.getFunction(catalog, database, function);
        return optional.isPresent();
    }

    @Override
    public void insertFunction(String catalog, String database, CatalogFunctionDTO function) throws DatabaseNotExistException, FunctionAlreadyExistException {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogFunctionMapper catalogFunctionMapper = (CatalogFunctionMapper)sqlSession.getMapper(CatalogFunctionMapper.class);
            CatalogDatabaseDTO catalogDatabaseDTO = this.getDatabase(catalog, database).orElseThrow(() -> new DatabaseNotExistException(catalog, database));
            if (this.functionExists(catalog, database, function.getName())) {
                throw new FunctionAlreadyExistException(catalog, new ObjectPath(database, function.getName()));
            }
            CatalogFunction record = CatalogFunctionConvert.INSTANCE.toDo(function);
            record.setDatabaseId(catalogDatabaseDTO.getId());
            catalogFunctionMapper.insert(record);
            sqlSession.commit();
        }
    }

    @Override
    public void updateFunction(String catalog, String database, CatalogFunctionDTO function) throws FunctionNotExistException {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogFunctionMapper catalogFunctionMapper = (CatalogFunctionMapper)sqlSession.getMapper(CatalogFunctionMapper.class);
            if (!this.functionExists(catalog, database, function.getName())) {
                throw new FunctionNotExistException(catalog, new ObjectPath(database, function.getName()));
            }
            CatalogFunction record = CatalogFunctionConvert.INSTANCE.toDo(function);
            catalogFunctionMapper.updateById(record);
            sqlSession.commit();
        }
    }

    @Override
    public void deleteFunction(String catalog, String database, String functionName) throws FunctionNotExistException {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            CatalogFunctionMapper catalogFunctionMapper = (CatalogFunctionMapper)sqlSession.getMapper(CatalogFunctionMapper.class);
            CatalogFunctionDTO catalogFunctionDTO = this.getFunction(catalog, database, functionName).orElseThrow(() -> new FunctionNotExistException(catalog, new ObjectPath(database, functionName)));
            CatalogFunction record = CatalogFunctionConvert.INSTANCE.toDo(catalogFunctionDTO);
            catalogFunctionMapper.deleteById(record.getId());
            sqlSession.commit();
        }
    }
}

