/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.sakura.common.util;

import java.util.ArrayList;
import java.util.List;

public enum SqlUtil {

    private static final String STATEMENT_DELIMITER = ";";
    private static final String LINE_DELIMITER = "\n";
    private static final String COMMENT_PATTERN = "(--.*)|(((\\/\\*)+?[\\w\\W]+?(\\*\\/)+))";

    public static List<String> parseStatements(String script) {
        String formatted = SqlUtil.formatSqlFile(script).replaceAll(COMMENT_PATTERN, "");
        ArrayList<String> statements = new ArrayList<String>();
        StringBuilder current = null;
        boolean statementSet = false;
        for (String line : formatted.split(STATEMENT_DELIMITER)) {
            String trimmed = line.trim();
            if (trimmed.isBlank()) continue;
            if (current == null) {
                current = new StringBuilder();
            }
            if (trimmed.startsWith("EXECUTE STATEMENT SET")) {
                statementSet = true;
            }
            current.append(trimmed);
            current.append(STATEMENT_DELIMITER);
            current.append(LINE_DELIMITER);
            if (statementSet && !trimmed.endsWith("END")) continue;
            statements.add(current.toString());
            statementSet = false;
            current = null;
        }
        return statements;
    }

    private static String formatSqlFile(String content) {
        String trimmed = content.trim();
        StringBuilder formatted = new StringBuilder();
        formatted.append(trimmed);
        if (!trimmed.endsWith(STATEMENT_DELIMITER)) {
            formatted.append(STATEMENT_DELIMITER);
        }
        formatted.append(LINE_DELIMITER);
        return formatted.toString();
    }

    public static String format(String script) {
        return script.replaceAll("--[^\r\n]*", "").replace('\r', ' ').replace('\n', ' ').replaceAll(" {2,}", " ").replaceAll("/\\*.+?\\*/", "").replaceAll(" {2,}", " ");
    }
}

