/*
 * Decompiled with CFR 0.152.
 */
package cn.smilevers.xxljob.spring.boot.autoconfigure;

import cn.smilevers.xxljob.spring.boot.autoconfigure.XxljobProperties;
import com.xxl.job.core.executor.XxlJobExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={XxljobProperties.class})
@ConditionalOnProperty(prefix="xxl.job")
public class XxlJobConfig {
    public static Logger logger = LoggerFactory.getLogger(XxlJobConfig.class);
    @Autowired
    private XxljobProperties xxljobProperties;

    @Bean(initMethod="start", destroyMethod="destroy")
    public XxlJobExecutor xxlJobExecutor() {
        logger.info("====xxl-job config init====");
        XxlJobExecutor xxlJobSpringExecutor = new XxlJobExecutor();
        xxlJobSpringExecutor.setAdminAddresses(this.xxljobProperties.getAdmin().getAddresses());
        xxlJobSpringExecutor.setAppName(this.xxljobProperties.getExecutor().getAppName());
        xxlJobSpringExecutor.setIp(this.xxljobProperties.getExecutor().getIp());
        xxlJobSpringExecutor.setPort(Integer.valueOf(this.xxljobProperties.getExecutor().getPort()).intValue());
        xxlJobSpringExecutor.setAccessToken(this.xxljobProperties.getAccessToken());
        xxlJobSpringExecutor.setLogPath(this.xxljobProperties.getExecutor().getLogPath());
        return xxlJobSpringExecutor;
    }
}

