/*
 * Decompiled with CFR 0.152.
 */
package cn.smthit.v4.framework.beetlsql.data2;

import cn.smthit.v4.common.lang.kits.ClassKit;
import cn.smthit.v4.common.lang.kits.Property;
import cn.smthit.v4.common.lang.kits.StringKit;
import cn.smthit.v4.framework.beetlsql.data.EnumOrder;
import cn.smthit.v4.framework.beetlsql.data.OrderBy;
import cn.smthit.v4.framework.beetlsql.data2.ParamDTO;
import cn.smthit.v4.framework.beetlsql.data2.QueryParamDTO;
import cn.smthit.v4.framework.beetlsql.exception.PropertyNotFoundException;

public class PageQueryParam<C extends QueryParamDTO> {
    private int pageNumber;
    private int pageSize;
    private C params;
    private OrderBy orderBy;

    private PageQueryParam() {
    }

    public static <C extends QueryParamDTO> Builder<C> buidler() {
        return new Builder();
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public C getParams() {
        return this.params;
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public PageQueryParam<C> setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    public PageQueryParam<C> setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public PageQueryParam<C> setParams(C params) {
        this.params = params;
        return this;
    }

    public PageQueryParam<C> setOrderBy(OrderBy orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageQueryParam)) {
            return false;
        }
        PageQueryParam other = (PageQueryParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageNumber() != other.getPageNumber()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        C this$params = this.getParams();
        C other$params = other.getParams();
        if (this$params == null ? other$params != null : !this$params.equals(other$params)) {
            return false;
        }
        OrderBy this$orderBy = this.getOrderBy();
        OrderBy other$orderBy = other.getOrderBy();
        return !(this$orderBy == null ? other$orderBy != null : !((Object)this$orderBy).equals(other$orderBy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageQueryParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageNumber();
        result = result * 59 + this.getPageSize();
        C $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : $params.hashCode());
        OrderBy $orderBy = this.getOrderBy();
        result = result * 59 + ($orderBy == null ? 43 : ((Object)$orderBy).hashCode());
        return result;
    }

    public String toString() {
        return "PageQueryParam(pageNumber=" + this.getPageNumber() + ", pageSize=" + this.getPageSize() + ", params=" + this.getParams() + ", orderBy=" + this.getOrderBy() + ")";
    }

    public static class Builder<C extends QueryParamDTO> {
        private Class<C> cls;
        private int pageNumber;
        private int pageSize;
        private C params;
        private OrderBy orderBy;

        private Builder() {
        }

        public Builder<C> paramCls(Class<C> cls) {
            this.cls = cls;
            return this;
        }

        public Builder<C> params(C params) {
            if (params == null) {
                throw new IllegalArgumentException();
            }
            this.params = params;
            return this;
        }

        public <T, R> Builder<C> desc(Property<T, R> property) {
            this.checkClsExist();
            String fieldName = StringKit.enCodeUnderlined((String)ClassKit.getFieldName(property));
            if (this.params == null) {
                throw new IllegalArgumentException();
            }
            if (((QueryParamDTO)this.params).hasOrderProperty(fieldName)) {
                this.orderBy = new OrderBy(fieldName, EnumOrder.DESC);
                return this;
            }
            throw new PropertyNotFoundException(String.format("%s \u5c5e\u6027\u4e0d\u5b58\u5728", fieldName));
        }

        public <T, R> Builder<C> asc(Property<T, R> property) {
            this.checkClsExist();
            String fieldName = ClassKit.getFieldName(property);
            if (this.params == null) {
                throw new IllegalArgumentException();
            }
            if (((QueryParamDTO)this.params).hasOrderProperty(fieldName)) {
                this.orderBy = new OrderBy(fieldName, EnumOrder.ASC);
                return this;
            }
            throw new PropertyNotFoundException(String.format("%s \u5c5e\u6027\u4e0d\u5b58\u5728", fieldName));
        }

        public Builder<C> pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder<C> pageNumber(int pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public PageQueryParam<C> build() {
            this.checkClsExist();
            PageQueryParam<C> pageParam = new PageQueryParam<C>();
            ((ParamDTO)this.params).validate();
            pageParam.setParams(this.params);
            pageParam.setPageNumber(this.pageNumber);
            pageParam.setPageSize(this.pageSize);
            pageParam.setOrderBy(this.orderBy);
            return pageParam;
        }

        public PageQueryParam<C> build(Class<?> group) {
            this.checkClsExist();
            PageQueryParam<C> pageParam = new PageQueryParam<C>();
            ((ParamDTO)this.params).validate(group);
            pageParam.setParams(this.params);
            pageParam.setPageNumber(this.pageNumber);
            pageParam.setPageSize(this.pageSize);
            pageParam.setOrderBy(this.orderBy);
            return pageParam;
        }

        private void checkClsExist() {
            if (this.cls == null) {
                throw new IllegalArgumentException();
            }
        }

        public int getPageNumber() {
            return this.pageNumber;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public C getParams() {
            return this.params;
        }
    }
}

