/*
 * Decompiled with CFR 0.152.
 */
package cn.smthit.v4.mybatis.plus;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.transaction.annotation.Transactional;

public interface EntityMapper<T>
extends BaseMapper<T> {
    default public QueryWrapper<T> queryWrapper() {
        QueryWrapper queryWrapper = new QueryWrapper();
        return queryWrapper;
    }

    default public LambdaQueryWrapper<T> lambdaQueryWrapper() {
        return new LambdaQueryWrapper();
    }

    @Transactional(rollbackFor={Exception.class})
    default public boolean saveOrUpdate(T entity) {
        if (null == entity) {
            return false;
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo(entity.getClass());
        Assert.notNull((Object)tableInfo, (String)"error: can not execute. because can not find cache of TableInfo for entity!", (Object[])new Object[0]);
        String keyProperty = tableInfo.getKeyProperty();
        Assert.notEmpty((String)keyProperty, (String)"error: can not execute. because can not find column for id from entity!", (Object[])new Object[0]);
        Object idVal = tableInfo.getPropertyValue(entity, tableInfo.getKeyProperty());
        return !StringUtils.checkValNull((Object)idVal) && !Objects.isNull(this.selectById((Serializable)idVal)) ? SqlHelper.retBool((Integer)this.updateById(entity)) : SqlHelper.retBool((Integer)this.insert(entity));
    }
}

