/*
 * Decompiled with CFR 0.152.
 */
package cn.smthit.v4.mq.rabbitmq.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RabbitConfiguration.class);

    @Bean
    public RabbitTemplate createRabbitTemplate(ConnectionFactory factory) {
        RabbitTemplate template = new RabbitTemplate();
        template.setConnectionFactory(factory);
        template.setMessageConverter((MessageConverter)new Jackson2JsonMessageConverter());
        template.setMandatory(true);
        template.setConfirmCallback(new RabbitTemplate.ConfirmCallback(){

            public void confirm(CorrelationData correlationData, boolean ack, String cause) {
                log.debug("ConfirmCallback: " + correlationData + " ack: " + ack + " cause: " + cause);
            }
        });
        template.setReturnCallback(new RabbitTemplate.ReturnCallback(){

            public void returnedMessage(Message message, int replyCode, String replyText, String exchange, String routeKey) {
                log.debug("Return Callback, Message: " + message + ", replyCode: " + replyCode + ", replyText: " + replyText + ", exchange: " + exchange + ", routeKey: " + routeKey);
            }
        });
        return template;
    }
}

