/*
 * Decompiled with CFR 0.152.
 */
package cn.smthit.v4.redis;

import cn.smthit.v4.redis.cache.RedisKit;
import cn.smthit.v4.redis.id.BusinessNoGenerator;
import cn.smthit.v4.redis.lock.impl.RedissonDistributedLocker;
import cn.smthit.v4.redis.queue.impl.DistributeQueue;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import java.time.Duration;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@EnableCaching
@AutoConfigureBefore(value={RedisAutoConfiguration.class})
public class RedisConfig {
    @Value(value="${spring.redis.host:#{'127.0.0.1'}}")
    private String hostName;
    @Value(value="${spring.redis.port:#{6379}}")
    private int port;
    @Value(value="${spring.redis.password:#{123456}}")
    private String password;
    @Value(value="${spring.redis.timeout:#{3000}}")
    private int timeout;
    @Value(value="${spring.redis.lettuce.pool.max-idle:#{16}}")
    private int maxIdle;
    @Value(value="${spring.redis.lettuce.pool.min-idle:#{1}}")
    private int minIdle;
    @Value(value="${spring.redis.lettuce.pool.max-wait:#{16}}")
    private long maxWaitMillis;
    @Value(value="${spring.redis.lettuce.pool.max-active:#{16}}")
    private int maxActive;
    @Value(value="${spring.redis.database:#{0}}")
    private int databaseId;

    @Bean
    public LettuceConnectionFactory lettuceConnectionFactory() {
        RedisStandaloneConfiguration redisConfiguration = new RedisStandaloneConfiguration(this.hostName, this.port);
        redisConfiguration.setDatabase(this.databaseId);
        redisConfiguration.setPassword(this.password);
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxIdle(this.maxIdle);
        poolConfig.setMinIdle(this.minIdle);
        poolConfig.setMaxTotal(this.maxActive);
        poolConfig.setMaxWaitMillis(this.maxWaitMillis);
        LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder builder = LettucePoolingClientConfiguration.builder().commandTimeout(Duration.ofMillis(this.timeout));
        LettucePoolingClientConfiguration lettucePoolingClientConfiguration = builder.build();
        builder.poolConfig(poolConfig);
        LettuceConnectionFactory factory = new LettuceConnectionFactory((RedisConfiguration)redisConfiguration, (LettuceClientConfiguration)lettucePoolingClientConfiguration);
        return factory;
    }

    @Bean
    public RedisTemplate<String, Object> redisTemplate(LettuceConnectionFactory lettuceConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)lettuceConnectionFactory);
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)stringRedisSerializer);
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        objectMapper.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL);
        jackson2JsonRedisSerializer.setObjectMapper(objectMapper);
        redisTemplate.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    @Bean
    public BusinessNoGenerator businessNoGenerator() {
        return new BusinessNoGenerator();
    }

    @Bean
    public RedissonDistributedLocker redissonDistributedLocker() {
        return new RedissonDistributedLocker();
    }

    @Bean
    public RedisKit RedisKit() {
        return new RedisKit();
    }

    @Bean
    public DistributeQueue distributeQueue() {
        return new DistributeQueue();
    }
}

