/*
 * Decompiled with CFR 0.152.
 */
package gateway.api;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import gateway.api.JsonUtils;
import gateway.api.NotExceptException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HeaderElement;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.DefaultClientConnectionReuseStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.IdleConnectionEvictor;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.EntityUtils;

public abstract class HttpClientHelper {
    private static final Log Log = LogFactory.getLog(HttpClientHelper.class);
    static HttpClientConnectManagerProperty DEFAULT_HCCM_PROPERTIES = new HttpClientConnectManagerProperty();
    private static HttpClientConnectionManager _defaultSingletonConnectionManager;
    private static HttpClient _defaultSingletonHttpClient;
    public static final Charset HttpResponseDefaultCharset;
    public static final HttpResponseStringExtractor RESPONSE_STRING_EXTRACTOR;
    public static final HttpResponseBytesExtractor RESPONSE_BYTES_EXTRACTOR;
    public static final HttpResponseVoidExtractor RESPONSE_VOID_EXTRACTOR;
    public static final HttpResponseGsonExtractor RESPONSE_GSON_EXTRACTOR;

    public static HttpClientConnectManagerProperty getDefaultConnectManagerProperty() {
        return DEFAULT_HCCM_PROPERTIES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createDefaultSingletonHttpClient() {
        Class<HttpClientHelper> clazz = HttpClientHelper.class;
        synchronized (HttpClientHelper.class) {
            if (_defaultSingletonHttpClient != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            HttpClientConnectManagerProperty prop = DEFAULT_HCCM_PROPERTIES;
            ConnectionKeepAliveStrategy keep_alive_strategy = HttpClientHelper.createConnectionKeepAliveStrategy(prop);
            HttpRequestRetryHandler request_retry_handler = HttpClientHelper.createHttpRequestRetryHandler(prop);
            _defaultSingletonConnectionManager = new SingletonHttpClientConnectionManager(HttpClientHelper.createHttpClientConnectionManager(prop));
            _defaultSingletonHttpClient = new SingletonHttpClient(HttpClientHelper.createHttpClient(prop, _defaultSingletonConnectionManager, keep_alive_strategy, request_retry_handler));
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static void reCreateDefaultSingletonHttpClient() {
        HttpClientHelper.destorySingletonHttpClientObjects();
        HttpClientHelper.createDefaultSingletonHttpClient();
    }

    public static HttpClientConnectionManager getSingletonConnectionManager() {
        return _defaultSingletonConnectionManager;
    }

    public static HttpClient getSingletonHttpClient() {
        return _defaultSingletonHttpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destorySingletonHttpClientObjects() {
        Class<HttpClientHelper> clazz = HttpClientHelper.class;
        synchronized (HttpClientHelper.class) {
            if (_defaultSingletonHttpClient != null) {
                if (_defaultSingletonHttpClient instanceof SingletonHttpClient) {
                    HttpClientUtils.closeQuietly(((SingletonHttpClient)_defaultSingletonHttpClient).impl);
                } else {
                    HttpClientUtils.closeQuietly(_defaultSingletonHttpClient);
                }
                _defaultSingletonHttpClient = null;
            }
            if (_defaultSingletonConnectionManager != null) {
                if (_defaultSingletonConnectionManager instanceof SingletonHttpClientConnectionManager) {
                    ((SingletonHttpClientConnectionManager)_defaultSingletonConnectionManager).impl.shutdown();
                } else {
                    _defaultSingletonConnectionManager.shutdown();
                }
                _defaultSingletonConnectionManager = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void requestExecute(HttpUriRequest request, HttpContext context) throws Exception {
        HttpClientHelper.requestExecute(request, context, RESPONSE_VOID_EXTRACTOR);
    }

    public static void requestExecute(HttpUriRequest request) throws Exception {
        HttpClientHelper.requestExecute(request, HttpClientContext.create(), RESPONSE_VOID_EXTRACTOR);
    }

    public static String requestExecuteAsString(HttpUriRequest request, HttpContext context, Charset charset) throws Exception {
        return HttpClientHelper.requestExecute(request, context, HttpClientHelper.getHttpResponseStringExtractorByCharset(charset));
    }

    public static String requestExecuteAsString(HttpUriRequest request, HttpContext context, String charset) throws Exception {
        return HttpClientHelper.requestExecute(request, context, HttpClientHelper.getHttpResponseStringExtractorByCharset(charset));
    }

    public static String requestExecuteAsString(HttpUriRequest request, Charset charset) throws Exception {
        return HttpClientHelper.requestExecute(request, HttpClientContext.create(), HttpClientHelper.getHttpResponseStringExtractorByCharset(charset));
    }

    public static String requestExecuteAsString(HttpUriRequest request, String charset) throws Exception {
        return HttpClientHelper.requestExecute(request, HttpClientContext.create(), HttpClientHelper.getHttpResponseStringExtractorByCharset(charset));
    }

    public static String requestExecuteAsString(HttpUriRequest request, HttpContext context) throws Exception {
        return HttpClientHelper.requestExecute(request, context, RESPONSE_STRING_EXTRACTOR);
    }

    public static String requestExecuteAsString(HttpUriRequest request) throws Exception {
        return HttpClientHelper.requestExecute(request, HttpClientContext.create(), RESPONSE_STRING_EXTRACTOR);
    }

    public static byte[] requestExecuteAsBytes(HttpUriRequest request, HttpContext context) throws Exception {
        return HttpClientHelper.requestExecute(request, context, RESPONSE_BYTES_EXTRACTOR);
    }

    public static byte[] requestExecuteAsBytes(HttpUriRequest request) throws Exception {
        return HttpClientHelper.requestExecute(request, HttpClientContext.create(), RESPONSE_BYTES_EXTRACTOR);
    }

    public static JsonObject requestExecuteAsJson(HttpUriRequest request, HttpContext context) throws Exception {
        request.setHeader("Accept", "application/json");
        return HttpClientHelper.requestExecute(request, context, RESPONSE_GSON_EXTRACTOR);
    }

    public static JsonObject requestExecuteAsJson(HttpUriRequest request) throws Exception {
        request.setHeader("Accept", "application/json");
        return HttpClientHelper.requestExecute(request, HttpClientContext.create(), RESPONSE_GSON_EXTRACTOR);
    }

    public static <T> T requestExecuteAsObject(HttpUriRequest request, HttpContext context, Class<T> clazz) throws Exception {
        request.setHeader("Accept", "application/json");
        return HttpClientHelper.requestExecute(request, context, HttpClientHelper.createHttpResponseObjectExtractor(clazz, false));
    }

    public static <T> T requestExecuteAsObject(HttpUriRequest request, Class<T> clazz) throws Exception {
        request.setHeader("Accept", "application/json");
        return HttpClientHelper.requestExecute(request, HttpClientContext.create(), HttpClientHelper.createHttpResponseObjectExtractor(clazz, false));
    }

    public static <T> T requestExecuteAsObject(HttpUriRequest request, HttpContext context, Class<T> clazz, boolean evelope_response) throws Exception {
        request.setHeader("Accept", "application/json");
        return HttpClientHelper.requestExecute(request, context, HttpClientHelper.createHttpResponseObjectExtractor(clazz, evelope_response));
    }

    public static <T> T requestExecuteAsObject(HttpUriRequest request, Class<T> clazz, boolean evelope_response) throws Exception {
        request.setHeader("Accept", "application/json");
        return HttpClientHelper.requestExecute(request, HttpClientContext.create(), HttpClientHelper.createHttpResponseObjectExtractor(clazz, evelope_response));
    }

    public static <T> T requestExecute(HttpUriRequest request, HttpResponseExtractor<T> response_extracter) throws Exception {
        return HttpClientHelper.requestExecute(HttpClientHelper.getSingletonHttpClient(), request, HttpClientContext.create(), response_extracter);
    }

    public static <T> T requestExecute(HttpUriRequest request, HttpContext context, HttpResponseExtractor<T> response_extracter) throws Exception {
        return HttpClientHelper.requestExecute(HttpClientHelper.getSingletonHttpClient(), request, context, response_extracter);
    }

    public static <T> T requestExecute(HttpClient hc, HttpUriRequest request, HttpResponseExtractor<T> response_extracter) throws Exception {
        return HttpClientHelper.requestExecute(hc, request, HttpClientContext.create(), response_extracter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T requestExecute(HttpClient hc, HttpUriRequest request, HttpContext context, HttpResponseExtractor<T> response_extracter) throws Exception {
        T t;
        HttpClient httpclient;
        HttpClient httpClient = httpclient = hc != null ? hc : HttpClientHelper.getSingletonHttpClient();
        if (httpclient == null) {
            throw new IllegalStateException("\u65e0\u53ef\u7528\u7684\u6267\u884c\u5668!");
        }
        if (request instanceof HttpRequestBase && ((HttpRequestBase)request).getConfig() == null) {
            ((HttpRequestBase)request).setConfig(HttpClientHelper.getDefaultRequestConfig());
        }
        HttpResponse response = null;
        try {
            try {
                response = httpclient.execute(request, context);
            }
            catch (IOException e) {
                throw new IOException("\u8bf7\u6c42\u670d\u52a1\u65f6\u51fa\u9519: " + e.getMessage(), e);
            }
            t = response_extracter.extract(response);
        }
        catch (Throwable throwable) {
            HttpClientUtils.closeQuietly(response);
            throw throwable;
        }
        HttpClientUtils.closeQuietly(response);
        return t;
    }

    public static ConnectionKeepAliveStrategy createConnectionKeepAliveStrategy(final HttpClientConnectManagerProperty prop) {
        ConnectionKeepAliveStrategy ret = new ConnectionKeepAliveStrategy(){

            @Override
            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                Args.notNull(response, "HTTP response");
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    String value = he.getValue();
                    if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                    try {
                        return Long.parseLong(value) * 1000L;
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
                return prop.getTimeLive();
            }
        };
        return ret;
    }

    public static IdleConnectionEvictor createIdleConnectionEvictor(HttpClientConnectionManager cm, long idle_check_inteval, long max_idle_time, TimeUnit time_unit) {
        return new IdleConnectionEvictor(cm, idle_check_inteval, time_unit, max_idle_time, time_unit);
    }

    public static HttpClientConnectionManager createHttpClientConnectionManager(HttpClientConnectManagerProperty prop) {
        PoolingHttpClientConnectionManager pcm = new PoolingHttpClientConnectionManager(prop.getTimeLive(), TimeUnit.MILLISECONDS);
        pcm.setMaxTotal(prop.getMaxTotal());
        pcm.setDefaultMaxPerRoute(prop.getMaxPerRoute());
        IdleConnectionEvictor idle_conn_evictor = HttpClientHelper.createIdleConnectionEvictor(pcm, prop.getIdleCheckInterval(), prop.getMaxIdleTime(), TimeUnit.MILLISECONDS);
        idle_conn_evictor.start();
        return new InnerHttpClientConnectionManager(pcm, idle_conn_evictor);
    }

    public static HttpRequestRetryHandler createHttpRequestRetryHandler(HttpClientConnectManagerProperty prop) {
        return new InnerHttpRequestRetryHandler(prop);
    }

    public static HttpClientBuilder createDefaultHttpClientBuilder() {
        return HttpClientHelper.createHttpClientBuilder(HttpClientHelper.getDefaultConnectManagerProperty(), HttpClientHelper.getSingletonConnectionManager(), HttpClientHelper.createConnectionKeepAliveStrategy(HttpClientHelper.getDefaultConnectManagerProperty()), HttpClientHelper.createHttpRequestRetryHandler(HttpClientHelper.getDefaultConnectManagerProperty()));
    }

    public static HttpClientBuilder createHttpClientBuilder(HttpClientConnectManagerProperty prop, HttpClientConnectionManager httpClientConnectionManager, ConnectionKeepAliveStrategy connectionKeepAliveStrategy, HttpRequestRetryHandler httpRequestRetryHandler) {
        HttpClientBuilder hb = HttpClients.custom().setConnectionManager(httpClientConnectionManager).setRetryHandler(httpRequestRetryHandler).setConnectionManagerShared(true);
        if (!prop.isSslVerifyHost()) {
            hb.setSSLHostnameVerifier(new NoopHostnameVerifier());
        }
        hb.setKeepAliveStrategy(connectionKeepAliveStrategy);
        hb.setConnectionReuseStrategy(DefaultClientConnectionReuseStrategy.INSTANCE);
        if (prop.getProxyHost() != null && prop.getProxyHost().length() > 0 && prop.getProxyPort() > 0) {
            hb.setProxy(new HttpHost(prop.getProxyHost(), prop.getProxyPort()));
        }
        return hb;
    }

    public static HttpClient createHttpClient(HttpClientConnectManagerProperty prop, HttpClientConnectionManager httpClientConnectionManager, ConnectionKeepAliveStrategy connectionKeepAliveStrategy, HttpRequestRetryHandler httpRequestRetryHandler) {
        HttpClientBuilder hb = HttpClients.custom().setConnectionManager(httpClientConnectionManager).setRetryHandler(httpRequestRetryHandler).setConnectionManagerShared(true);
        if (!prop.isSslVerifyHost()) {
            hb.setSSLHostnameVerifier(new NoopHostnameVerifier());
        }
        hb.setKeepAliveStrategy(connectionKeepAliveStrategy);
        hb.setConnectionReuseStrategy(DefaultClientConnectionReuseStrategy.INSTANCE);
        if (prop.getProxyHost() != null && prop.getProxyHost().length() > 0 && prop.getProxyPort() > 0) {
            hb.setProxy(new HttpHost(prop.getProxyHost(), prop.getProxyPort()));
        }
        return hb.build();
    }

    public static RequestConfig createRequestConfig(HttpClientConnectManagerProperty prop) {
        return RequestConfig.custom().setConnectionRequestTimeout(prop.getRequestTimeout().intValue()).setConnectTimeout(prop.getConnectTimeout().intValue()).setSocketTimeout(prop.getSocketTimeout().intValue()).build();
    }

    public static RequestConfig getDefaultRequestConfig() {
        return HttpClientHelper.createRequestConfig(HttpClientHelper.getDefaultConnectManagerProperty());
    }

    public static HttpResponseStringExtractor getHttpResponseStringExtractorByCharset(Charset charset) {
        return new HttpResponseStringExtractor(charset);
    }

    public static HttpResponseStringExtractor getHttpResponseStringExtractorByCharset(String charset) {
        return new HttpResponseStringExtractor(Charset.forName(charset));
    }

    public static Charset getResponseContentCharset(HttpResponse response) {
        return HttpClientHelper.getResponseContentCharset(response, HttpResponseDefaultCharset);
    }

    public static Charset getResponseContentCharset(HttpResponse response, Charset default_charset) {
        if (response.getEntity().getContentEncoding() == null || StringUtils.isBlank(response.getEntity().getContentEncoding().getValue())) {
            return default_charset == null ? Charset.forName("UTF-8") : default_charset;
        }
        try {
            return Charset.forName(response.getEntity().getContentEncoding().getValue());
        }
        catch (Throwable e) {
            if (Log.isDebugEnabled()) {
                Log.debug(e.getMessage(), e);
            }
            return default_charset == null ? Charset.forName("UTF-8") : default_charset;
        }
    }

    public static <T> HttpResponseObjectExtractor<T> createHttpResponseObjectExtractor(Class<T> clazz, boolean evelope_response) {
        return new HttpResponseObjectExtractor(clazz, evelope_response);
    }

    static {
        HttpClientHelper.createDefaultSingletonHttpClient();
        HttpResponseDefaultCharset = Charset.forName("UTF-8");
        RESPONSE_STRING_EXTRACTOR = new HttpResponseStringExtractor();
        RESPONSE_BYTES_EXTRACTOR = new HttpResponseBytesExtractor();
        RESPONSE_VOID_EXTRACTOR = new HttpResponseVoidExtractor();
        RESPONSE_GSON_EXTRACTOR = new HttpResponseGsonExtractor();
    }

    public static class HttpResponseObjectExtractor<T>
    implements HttpResponseExtractor<T> {
        private Type object_clazz;
        private boolean evelope_response;

        public HttpResponseObjectExtractor(Type clazz, boolean evelope_response) {
            this.object_clazz = clazz;
            this.evelope_response = evelope_response;
        }

        @Override
        public T extract(HttpResponse response) throws Exception {
            StatusLine state = response.getStatusLine();
            if (this.evelope_response) {
                JsonObject json_node = null;
                String json_error = null;
                try {
                    json_node = JsonUtils.fromJson(response.getEntity().getContent(), JsonObject.class);
                }
                catch (Throwable e) {
                    json_error = e.getMessage();
                }
                if (state.getStatusCode() < 200 || state.getStatusCode() >= 400 || json_node == null || json_node.get("code") == null || json_node.get("code").getAsInt() != 0) {
                    if (state.getStatusCode() == 404 || json_node != null && json_node.get("code") != null && json_node.get("code").getAsInt() == 404) {
                        return null;
                    }
                    throw new NotExceptException(json_node == null || json_node.get("code") == null ? state.getStatusCode() : json_node.get("code").getAsInt(), json_node == null || json_node.get("message") == null ? json_error : json_node.get("message").getAsString(), json_node == null || json_node.get("timestamp") == null ? new Date() : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(json_node.get("timestamp").getAsString()), json_node == null || json_node.get("exception") == null ? null : json_node.get("exception").getAsString(), json_node == null || json_node.get("path") == null ? null : json_node.get("path").getAsString());
                }
                if (!json_node.has("data")) {
                    return null;
                }
                if (Objects.equals(this.object_clazz, Void.class)) {
                    return null;
                }
                if (TypeUtils.isArrayType(this.object_clazz)) {
                    return JsonUtils.fromJson(json_node.get("data"), TypeToken.getArray(TypeUtils.getArrayComponentType(this.object_clazz)).getType());
                }
                if (this.object_clazz instanceof ParameterizedType) {
                    Class<?> rawType = TypeUtils.getRawType(this.object_clazz, null);
                    Object val = JsonUtils.fromJson(json_node.get("data"), TypeToken.getParameterized(rawType, new ArrayList<Type>(TypeUtils.getTypeArguments((ParameterizedType)this.object_clazz).values()).toArray(new Type[0])).getType());
                    return val;
                }
                if (this.object_clazz instanceof Class) {
                    return JsonUtils.fromJson(json_node.get("data"), TypeToken.get((Class)this.object_clazz).getType());
                }
                return JsonUtils.fromJson(json_node.get("data"), TypeToken.get(this.object_clazz).getType());
            }
            if (state.getStatusCode() < 200 || state.getStatusCode() >= 400) {
                throw new NotExceptException(state.getStatusCode(), IOUtils.toString(response.getEntity().getContent(), HttpClientHelper.getResponseContentCharset(response)));
            }
            return JsonUtils.fromJson(response.getEntity().getContent(), TypeToken.get(this.object_clazz).getType());
        }
    }

    public static class HttpResponseGsonExtractor
    implements HttpResponseExtractor<JsonObject> {
        private HttpResponseGsonExtractor() {
        }

        @Override
        public JsonObject extract(HttpResponse response) throws Exception {
            StatusLine state = response.getStatusLine();
            if (state.getStatusCode() < 200 || state.getStatusCode() >= 400) {
                throw new NotExceptException(state.getStatusCode(), MessageFormat.format("\u670d\u52a1\u7aef\u5e94\u7b54\u9519\u8bef: {1}", state.getStatusCode(), EntityUtils.toString(response.getEntity(), HttpClientHelper.getResponseContentCharset(response))));
            }
            return JsonUtils.fromJson(response.getEntity().getContent(), JsonObject.class);
        }
    }

    public static class HttpResponseVoidExtractor
    implements HttpResponseExtractor<Void> {
        private HttpResponseVoidExtractor() {
        }

        @Override
        public Void extract(HttpResponse response) throws Exception {
            StatusLine state = response.getStatusLine();
            if (state.getStatusCode() < 200 || state.getStatusCode() >= 400) {
                throw new NotExceptException(state.getStatusCode(), MessageFormat.format("\u670d\u52a1\u7aef\u5e94\u7b54\u9519\u8bef: {1}", state.getStatusCode(), EntityUtils.toString(response.getEntity(), HttpClientHelper.getResponseContentCharset(response))));
            }
            return null;
        }
    }

    public static class HttpResponseBytesExtractor
    implements HttpResponseExtractor<byte[]> {
        private HttpResponseBytesExtractor() {
        }

        @Override
        public byte[] extract(HttpResponse response) throws Exception {
            StatusLine state = response.getStatusLine();
            if (state.getStatusCode() < 200 || state.getStatusCode() >= 400) {
                throw new Exception(MessageFormat.format("\u670d\u52a1\u7aef\u5e94\u7b54\u9519\u8bef(CODE={0}: {1}", state.getStatusCode(), EntityUtils.toString(response.getEntity(), HttpResponseDefaultCharset)));
            }
            return EntityUtils.toByteArray(response.getEntity());
        }
    }

    public static class HttpResponseStringExtractor
    implements HttpResponseExtractor<String> {
        private Charset charset = HttpResponseDefaultCharset;

        private HttpResponseStringExtractor(Charset charset) {
            this.charset = charset;
        }

        private HttpResponseStringExtractor() {
        }

        @Override
        public String extract(HttpResponse response) throws Exception {
            StatusLine state = response.getStatusLine();
            if (state.getStatusCode() < 200 || state.getStatusCode() >= 400) {
                throw new Exception(MessageFormat.format("\u670d\u52a1\u7aef\u5e94\u7b54\u9519\u8bef(CODE={0}: {1}", state.getStatusCode(), EntityUtils.toString(response.getEntity(), HttpResponseDefaultCharset)));
            }
            return EntityUtils.toString(response.getEntity(), HttpClientHelper.getResponseContentCharset(response, this.charset));
        }
    }

    public static interface HttpResponseExtractor<T> {
        public T extract(HttpResponse var1) throws Exception;
    }

    private static class InnerHttpRequestRetryHandler
    implements HttpRequestRetryHandler {
        private HttpClientConnectManagerProperty prop;

        private InnerHttpRequestRetryHandler(HttpClientConnectManagerProperty prop) {
            this.prop = prop;
        }

        @Override
        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            if (executionCount >= this.prop.getRetry()) {
                return false;
            }
            if (exception instanceof NoHttpResponseException) {
                return true;
            }
            if (exception instanceof SSLHandshakeException) {
                return false;
            }
            if (exception instanceof InterruptedIOException) {
                return false;
            }
            if (exception instanceof UnknownHostException) {
                return false;
            }
            if (exception instanceof ConnectTimeoutException) {
                return false;
            }
            if (exception instanceof SSLException) {
                return false;
            }
            HttpClientContext clientContext = HttpClientContext.adapt(context);
            HttpRequest request = clientContext.getRequest();
            return !(request instanceof HttpEntityEnclosingRequest);
        }
    }

    private static class InnerHttpClientConnectionManager
    implements HttpClientConnectionManager,
    Closeable {
        private HttpClientConnectionManager pcm;
        private IdleConnectionEvictor idle_conn_evictor;

        private InnerHttpClientConnectionManager(HttpClientConnectionManager p, IdleConnectionEvictor conn_evictor) {
            this.pcm = p;
            this.idle_conn_evictor = conn_evictor;
        }

        @Override
        public void upgrade(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
            this.pcm.upgrade(conn, route, context);
        }

        @Override
        public void shutdown() {
            this.idle_conn_evictor.shutdown();
            this.pcm.shutdown();
        }

        @Override
        public void routeComplete(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
            this.pcm.routeComplete(conn, route, context);
        }

        @Override
        public ConnectionRequest requestConnection(HttpRoute route, Object state) {
            return this.pcm.requestConnection(route, state);
        }

        @Override
        public void releaseConnection(HttpClientConnection conn, Object newState, long validDuration, TimeUnit timeUnit) {
            this.pcm.releaseConnection(conn, newState, validDuration, timeUnit);
        }

        @Override
        public void connect(HttpClientConnection conn, HttpRoute route, int connectTimeout, HttpContext context) throws IOException {
            this.pcm.connect(conn, route, connectTimeout, context);
        }

        @Override
        public void closeIdleConnections(long idletime, TimeUnit tunit) {
            this.pcm.closeIdleConnections(idletime, tunit);
        }

        @Override
        public void closeExpiredConnections() {
            this.pcm.closeExpiredConnections();
        }

        @Override
        public void close() throws IOException {
            this.shutdown();
        }
    }

    private static class SingletonHttpClientConnectionManager
    implements HttpClientConnectionManager,
    Closeable {
        private HttpClientConnectionManager impl;

        public SingletonHttpClientConnectionManager(HttpClientConnectionManager impl) {
            if (impl instanceof SingletonHttpClientConnectionManager) {
                impl = ((SingletonHttpClientConnectionManager)impl).impl;
            } else {
                this.impl = impl;
            }
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public ConnectionRequest requestConnection(HttpRoute route, Object state) {
            return this.impl.requestConnection(route, state);
        }

        @Override
        public void releaseConnection(HttpClientConnection conn, Object newState, long validDuration, TimeUnit timeUnit) {
            this.impl.releaseConnection(conn, newState, validDuration, timeUnit);
        }

        @Override
        public void connect(HttpClientConnection conn, HttpRoute route, int connectTimeout, HttpContext context) throws IOException {
            this.impl.connect(conn, route, connectTimeout, context);
        }

        @Override
        public void upgrade(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
            this.impl.upgrade(conn, route, context);
        }

        @Override
        public void routeComplete(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
            this.impl.routeComplete(conn, route, context);
        }

        @Override
        public void closeIdleConnections(long idletime, TimeUnit tunit) {
            this.impl.closeIdleConnections(idletime, tunit);
        }

        @Override
        public void closeExpiredConnections() {
            this.impl.closeExpiredConnections();
        }

        @Override
        public void shutdown() {
        }
    }

    private static class SingletonHttpClient
    implements HttpClient,
    Closeable {
        private HttpClient impl;

        private SingletonHttpClient(HttpClient impl) {
            this.impl = impl instanceof SingletonHttpClient ? ((SingletonHttpClient)impl).impl : impl;
        }

        @Override
        public HttpParams getParams() {
            return this.impl.getParams();
        }

        @Override
        public ClientConnectionManager getConnectionManager() {
            return this.impl.getConnectionManager();
        }

        @Override
        public HttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
            return this.impl.execute(request);
        }

        @Override
        public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
            return this.impl.execute(request, context);
        }

        @Override
        public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
            return this.impl.execute(target, request);
        }

        @Override
        public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
            return this.impl.execute(target, request, context);
        }

        @Override
        public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
            return this.impl.execute(request, responseHandler);
        }

        @Override
        public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
            return this.impl.execute(request, responseHandler, context);
        }

        @Override
        public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
            return this.impl.execute(target, request, responseHandler);
        }

        @Override
        public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
            return this.impl.execute(target, request, responseHandler, context);
        }

        @Override
        public void close() throws IOException {
        }
    }

    public static class HttpClientConnectManagerProperty
    implements Serializable {
        private static final long serialVersionUID = -6518068245615660705L;
        private String proxyHost;
        private int proxyPort;
        private boolean sslVerifyHost = true;
        private Integer maxRetry = 3;
        private Integer maxTotal = 1000;
        private Integer maxPerRoute = 100;
        private Long timeLive = 86400000L;
        private Long maxIdleTime = 18000000L;
        private Long idleCheckInterval = 5000L;
        private Long requestTimeout = 6000L;
        private Long connectTimeout = 6000L;
        private Long SocketTimeout = 6000L;

        public Long getMaxIdleTime() {
            return this.maxIdleTime;
        }

        public void setMaxIdleTime(Long maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
        }

        public Long getIdleCheckInterval() {
            return this.idleCheckInterval;
        }

        public void setIdleCheckInterval(Long idleCheckInterval) {
            this.idleCheckInterval = idleCheckInterval;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public void setProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
        }

        public int getProxyPort() {
            return this.proxyPort;
        }

        public void setProxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
        }

        public boolean isSslVerifyHost() {
            return this.sslVerifyHost;
        }

        public void setSslVerifyHost(boolean sslVerifyHostName) {
            this.sslVerifyHost = sslVerifyHostName;
        }

        public Integer getMaxTotal() {
            return this.maxTotal;
        }

        public void setMaxTotal(Integer maxTotal) {
            this.maxTotal = maxTotal;
        }

        public Integer getMaxPerRoute() {
            return this.maxPerRoute;
        }

        public void setMaxPerRoute(Integer maxPerRoute) {
            this.maxPerRoute = maxPerRoute;
        }

        public Long getTimeLive() {
            return this.timeLive;
        }

        public void setTimeLive(Long timeLiveMS) {
            this.timeLive = timeLiveMS;
        }

        public Long getRequestTimeout() {
            return this.requestTimeout;
        }

        public void setRequestTimeout(Long requestTimeout) {
            this.requestTimeout = requestTimeout;
        }

        public Long getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(Long connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public Long getSocketTimeout() {
            return this.SocketTimeout;
        }

        public void setSocketTimeout(Long socketTimeout) {
            this.SocketTimeout = socketTimeout;
        }

        public Integer getRetry() {
            return this.maxRetry;
        }

        public void setRetry(Integer retry) {
            this.maxRetry = retry;
        }

        public Integer getMaxRetry() {
            return this.maxRetry;
        }

        public void setMaxRetry(Integer maxRetry) {
            this.maxRetry = maxRetry;
        }
    }
}

