/*
 * Decompiled with CFR 0.152.
 */
package gateway.api;

import gateway.api.Version;
import gateway.api.ViaGatewayUtils;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttpClientInterceptor
implements Interceptor {
    private String userAgent = "ApiHelper/" + Version.STRING;

    public OkHttpClientInterceptor(String user_agent) {
        if (user_agent != null && user_agent.length() > 0) {
            this.userAgent = user_agent;
        }
    }

    protected Request.Builder newRequestBuilder(Interceptor.Chain chain) {
        Request.Builder new_req_builder = chain.request().newBuilder();
        ViaGatewayUtils.initRequestChainForHttpClient(new_req_builder);
        new_req_builder.removeHeader("User-Agent").addHeader("User-Agent", this.userAgent);
        return new_req_builder;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        return chain.proceed(this.newRequestBuilder(chain).build());
    }
}

