/*
 * Decompiled with CFR 0.152.
 */
package gateway.api;

import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import gateway.api.EnvelopeResponse;
import gateway.api.JsonUtils;
import gateway.api.NotExceptException;
import gateway.api.NotFoundException;
import gateway.api.Nullable;
import gateway.api.OnePageOnly;
import gateway.api.OnlyhPageList;
import gateway.api.Page;
import gateway.api.Result;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.Retrofit;

public class SynchCallAdapterFactory
extends CallAdapter.Factory {
    public static CallAdapter.Factory create() {
        return new SynchCallAdapterFactory();
    }

    @Override
    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        if (SynchCallAdapterFactory.getRawType(returnType) == Call.class) {
            return null;
        }
        boolean is_envelope_resp = false;
        for (Annotation ann : annotations) {
            if (ann == null || !(ann instanceof EnvelopeResponse)) continue;
            is_envelope_resp = true;
            break;
        }
        boolean is_null_able = false;
        for (Annotation ann : annotations) {
            if (ann == null || !(ann instanceof Nullable)) continue;
            is_null_able = true;
            break;
        }
        boolean is_page_resp = false;
        for (Annotation ann : annotations) {
            if (ann != null && ann instanceof OnlyhPageList) {
                is_page_resp = true;
                break;
            }
            if (ann == null || !(ann instanceof OnePageOnly)) continue;
            is_page_resp = true;
            break;
        }
        if (is_envelope_resp) {
            if (returnType instanceof Result) {
                throw new IllegalStateException("Return type error when use @EnvelopeResponse!");
            }
            return new EnvelopeCallAdapter(returnType, is_page_resp, is_null_able);
        }
        return new ObjectCallAdapter(returnType, is_page_resp, is_null_able);
    }

    private static class ObjectCallAdapter
    implements CallAdapter<Object, Object> {
        private Type responseType;
        private boolean is_page_list = false;
        private boolean is_null_able = false;

        public ObjectCallAdapter(Type responseType, boolean is_page_list, boolean is_null_able) {
            this.responseType = responseType;
            this.is_page_list = is_page_list;
            this.is_null_able = is_null_able;
        }

        @Override
        public Type responseType() {
            return this.responseType;
        }

        @Override
        public Object adapt(Call<Object> call) {
            try {
                Response<Object> resp = call.execute();
                if (this.responseType instanceof Result) {
                    return resp.body();
                }
                if (this.responseType == Void.class) {
                    if (resp.code() < 200 || resp.code() >= 400) {
                        throw new NotExceptException(resp.code(), resp.message());
                    }
                    return null;
                }
                if (resp.code() < 200 || resp.code() >= 400) {
                    if (resp.code() == 404) {
                        if (this.is_null_able) {
                            return null;
                        }
                        throw new NotFoundException(resp.message());
                    }
                    throw new NotExceptException(resp.code(), resp.message());
                }
                List val = resp.body();
                if (val instanceof Page && this.is_page_list) {
                    val = ((Page)((Object)val)).data;
                }
                return val;
            }
            catch (IOException e) {
                if (this.responseType instanceof Result) {
                    return new Result(5000, e.getMessage());
                }
                throw new NotExceptException(5000, e.getMessage(), e);
            }
        }
    }

    private static class EnvelopeReturn {
        public int code;
        public String message;
        public JsonElement data;
        public Date timestamp;
        public String exception;
        public String path;

        private EnvelopeReturn() {
        }
    }

    private static class EnvelopeCallAdapter
    implements CallAdapter<Object, Object> {
        private Type responseType;
        private boolean is_page_resp = false;
        private boolean is_null_able = false;

        public EnvelopeCallAdapter(Type responseType, boolean is_page_resp, boolean is_null_able) {
            this.responseType = responseType;
            this.is_page_resp = is_page_resp;
            this.is_null_able = is_null_able;
            if (this.is_page_resp && responseType instanceof ParameterizedType) {
                this.responseType = TypeUtils.parameterize(Page.class, TypeUtils.getTypeArguments((ParameterizedType)responseType).entrySet().iterator().next().getValue());
            }
        }

        @Override
        public Type responseType() {
            return EnvelopeReturn.class;
        }

        @Override
        public Object adapt(Call<Object> call) {
            try {
                Response<Object> resp = call.execute();
                EnvelopeReturn ersp = (EnvelopeReturn)resp.body();
                if (resp.code() < 200 || resp.code() >= 400 || ersp == null || ersp.code != 0) {
                    if (ersp == null) {
                        StringWriter sbw = new StringWriter();
                        IOUtils.copy(resp.errorBody().byteStream(), (Writer)sbw, JsonUtils.JsonCharset);
                        try {
                            ersp = JsonUtils.fromJson(sbw.toString(), EnvelopeReturn.class);
                        }
                        catch (Throwable e) {
                            ersp = new EnvelopeReturn();
                            ersp.code = resp.code();
                            ersp.message = sbw.toString();
                            ersp.timestamp = new Date();
                            ersp.exception = e.getClass().getName();
                        }
                    }
                    if (resp.code() == 404 || ersp != null && ersp.code == 404) {
                        if (this.is_null_able || this.responseType == Void.class) {
                            return null;
                        }
                        throw new NotFoundException(ersp == null ? resp.message() : ersp.message);
                    }
                    throw new NotExceptException(ersp == null ? resp.code() : ersp.code, ersp == null ? resp.message() : ersp.message, ersp == null ? new Date() : ersp.timestamp, ersp == null ? null : ersp.exception, ersp == null ? null : ersp.path);
                }
                if (ersp.data == null) {
                    return null;
                }
                if (TypeUtils.isArrayType(this.responseType)) {
                    return JsonUtils.fromJson(ersp.data, TypeToken.getArray(TypeUtils.getArrayComponentType(this.responseType)).getType());
                }
                if (this.responseType instanceof ParameterizedType) {
                    Class<?> rawType = TypeUtils.getRawType(this.responseType, null);
                    Object val = JsonUtils.fromJson(ersp.data, TypeToken.getParameterized(rawType, new ArrayList<Type>(TypeUtils.getTypeArguments((ParameterizedType)this.responseType).values()).toArray(new Type[0])).getType());
                    if (val instanceof Page && this.is_page_resp) {
                        val = ((Page)val).data;
                    }
                    return val;
                }
                if (this.responseType instanceof Class) {
                    return JsonUtils.fromJson(ersp.data, TypeToken.get((Class)this.responseType).getType());
                }
                return JsonUtils.fromJson(ersp.data, TypeToken.get(this.responseType).getType());
            }
            catch (IOException e) {
                throw new NotExceptException(5000, e.getMessage(), e);
            }
        }
    }
}

