/*
 * Decompiled with CFR 0.152.
 */
package gateway.api;

import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import okhttp3.Request;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpMessage;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class ViaGatewayUtils {
    private static final Log Log = LogFactory.getLog(ViaGatewayUtils.class);

    public static String getClientRealIp() {
        return ViaGatewayUtils.getClientRealIp(ViaGatewayUtils.getHttpServletRequest());
    }

    public static String getClientRealIp(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String realIp = request.getRemoteAddr();
        String clientIp = request.getHeader("X-Forwarded-For");
        if (!StringUtils.isEmpty(clientIp)) {
            realIp = clientIp;
        } else {
            clientIp = request.getHeader("X-Real-IP");
            if (!StringUtils.isEmpty(clientIp)) {
                realIp = clientIp;
            }
        }
        return StringUtils.split(realIp, ",")[0];
    }

    public static String getClientUserAgent() {
        HttpServletRequest request = ViaGatewayUtils.getHttpServletRequest();
        if (request == null) {
            return null;
        }
        return request.getHeader("User-Agent");
    }

    public static String getClientUserAgent(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return request.getHeader("User-Agent");
    }

    public static Properties parseQueryStringParameters(String data) {
        return ViaGatewayUtils.parseQueryStringParameters(data, false);
    }

    @Deprecated
    public static HttpServletRequest GetHttpServletRequest() {
        return ViaGatewayUtils.getHttpServletRequest();
    }

    public static String getRequestRootViaGateway() {
        return ViaGatewayUtils.getRequestRootViaGateway(ViaGatewayUtils.getHttpServletRequest());
    }

    public static String getRequestRootViaGateway(HttpServletRequest request) {
        String proto = ViaGatewayUtils.getGatewayProto(request);
        StringBuffer sbf = new StringBuffer(proto);
        sbf.append("://").append(ViaGatewayUtils.getGatewayHost(request));
        int port = ViaGatewayUtils.getGatewayPort(request);
        if (StringUtils.equalsIgnoreCase(proto, "http") && port != 80 || StringUtils.equalsIgnoreCase(proto, "https") && port != 443) {
            sbf.append(":").append(port);
        }
        return sbf.toString();
    }

    public static String getGatewayProto() {
        return ViaGatewayUtils.getGatewayProto(ViaGatewayUtils.getHttpServletRequest());
    }

    public static String getGatewayProto(HttpServletRequest request) {
        if (ViaGatewayUtils.isRequestViaGateway(request)) {
            return request.getHeader("x-forwarded-proto");
        }
        return request.getScheme();
    }

    public static String getRequestURIViaGateway() {
        return ViaGatewayUtils.getRequestURIViaGateway(ViaGatewayUtils.getHttpServletRequest());
    }

    public static String getRequestURIViaGateway(HttpServletRequest request) {
        if (ViaGatewayUtils.isRequestViaGateway(request)) {
            return request.getHeader("x-source-uri");
        }
        return request.getRequestURI();
    }

    public static String getRequestURLViaGateway() {
        return ViaGatewayUtils.getRequestURIViaGateway(ViaGatewayUtils.getHttpServletRequest());
    }

    public static String getRequestURLViaGateway(HttpServletRequest request) {
        String proto = ViaGatewayUtils.getGatewayProto(request);
        StringBuffer sbf = new StringBuffer(proto);
        sbf.append("://").append(ViaGatewayUtils.getGatewayHost(request));
        int port = ViaGatewayUtils.getGatewayPort(request);
        if (StringUtils.equalsIgnoreCase(proto, "http") && port != 80 || StringUtils.equalsIgnoreCase(proto, "https") && port != 443) {
            sbf.append(":").append(port);
        }
        sbf.append(ViaGatewayUtils.getRequestURIViaGateway(request));
        return sbf.toString();
    }

    public static int getGatewayPort() {
        return ViaGatewayUtils.getGatewayPort(ViaGatewayUtils.getHttpServletRequest());
    }

    public static int getGatewayPort(HttpServletRequest request) {
        if (ViaGatewayUtils.isRequestViaGateway(request)) {
            String port_val = request.getHeader("x-forwarded-port");
            if (StringUtils.isEmpty(port_val)) {
                return request.getServerPort();
            }
            try {
                return Integer.parseInt(port_val);
            }
            catch (Throwable e) {
                request.getServerPort();
            }
        }
        return request.getServerPort();
    }

    public static Properties parseQueryStringParameters(String data, boolean val_url_decode) {
        String[] paramters = StringUtils.split(data, "&");
        Properties props = new Properties();
        for (String paramter : paramters) {
            String value;
            String name;
            block4: {
                int paramter_equals_pos;
                if (StringUtils.isEmpty(paramter) || (paramter_equals_pos = paramter.indexOf(61)) < 2) continue;
                name = paramter.substring(0, paramter_equals_pos);
                value = paramter.substring(paramter_equals_pos + 1);
                if (val_url_decode) {
                    try {
                        value = URLDecoder.decode(value, "UTF-8");
                    }
                    catch (Throwable e) {
                        if (!Log.isDebugEnabled()) break block4;
                        Log.debug("URLDecoder.decode error: " + e.getMessage(), e);
                    }
                }
            }
            props.setProperty(name, value);
        }
        return props;
    }

    public static String getRequestPageId() {
        HttpServletRequest request = ViaGatewayUtils.getHttpServletRequest();
        if (request == null) {
            return null;
        }
        String v = request.getRequestURI();
        int sp_lst = v.lastIndexOf(47);
        if (sp_lst >= 0 && ((v = v.substring(sp_lst + 1)).endsWith(".jsp") || v.endsWith(".zul") || v.endsWith(".html"))) {
            v = v.substring(0, v.length() - 4);
        }
        return v;
    }

    public static HttpServletRequest getHttpServletRequest() {
        ServletRequestAttributes sa = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (sa == null) {
            return null;
        }
        return sa.getRequest();
    }

    public static boolean isRequestViaWeb() {
        HttpServletRequest request = ViaGatewayUtils.getHttpServletRequest();
        return request != null;
    }

    public static boolean isRequestViaGateway() {
        return StringUtils.isNoneBlank(ViaGatewayUtils.getRequestIdViaGateway());
    }

    public static boolean isRequestViaGateway(HttpServletRequest request) {
        return StringUtils.isNoneBlank(ViaGatewayUtils.getRequestIdViaGateway(request));
    }

    public static String getRequestIdViaGateway() {
        return ViaGatewayUtils.getRequestIdViaGateway(ViaGatewayUtils.getHttpServletRequest());
    }

    public static String getRequestIdViaGateway(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return request.getHeader("x-request-id");
    }

    public static String getTraceParentIdViaGateway() {
        return ViaGatewayUtils.getTraceParentIdViaGateway(ViaGatewayUtils.getHttpServletRequest());
    }

    public static String getTraceParentIdViaGateway(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return request.getHeader("x-trace-parent");
    }

    public static String getTraceChainIdViaGateway() {
        return ViaGatewayUtils.getTraceChainIdViaGateway(ViaGatewayUtils.getHttpServletRequest());
    }

    public static String getTraceChainIdViaGateway(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return request.getHeader("x-app-sticky");
    }

    public static void firstRequestChainForHttpClient(HttpMessage http_msg) {
        if (!ViaGatewayUtils.isRequestViaGateway()) {
            return;
        }
        http_msg.addHeader("x-trace-parent", ViaGatewayUtils.getRequestIdViaGateway());
        http_msg.addHeader("x-app-sticky", ViaGatewayUtils.getRequestIdViaGateway());
    }

    public static void firstRequestChainForHttpClient(Request.Builder http_msg) {
        if (!ViaGatewayUtils.isRequestViaGateway()) {
            return;
        }
        http_msg.addHeader("x-trace-parent", ViaGatewayUtils.getRequestIdViaGateway());
        http_msg.addHeader("x-app-sticky", ViaGatewayUtils.getRequestIdViaGateway());
    }

    public static void copyRequestChainForHttpClient(HttpMessage http_msg) {
        if (!ViaGatewayUtils.isRequestViaGateway()) {
            return;
        }
        http_msg.addHeader("x-trace-parent", ViaGatewayUtils.getRequestIdViaGateway());
        http_msg.addHeader("x-app-sticky", ViaGatewayUtils.getTraceChainIdViaGateway());
    }

    public static void initRequestChainForHttpClient(HttpMessage http_msg) {
        if (ViaGatewayUtils.isRequestViaWeb()) {
            ViaGatewayUtils.firstRequestChainForHttpClient(http_msg);
        } else {
            ViaGatewayUtils.copyRequestChainForHttpClient(http_msg);
        }
    }

    public static void initRequestChainForHttpClient(Request.Builder http_msg) {
        if (ViaGatewayUtils.isRequestViaWeb()) {
            ViaGatewayUtils.firstRequestChainForHttpClient(http_msg);
        } else {
            ViaGatewayUtils.copyRequestChainForHttpClient(http_msg);
        }
    }

    public static void copyRequestChainForHttpClient(Request.Builder http_msg) {
        if (!ViaGatewayUtils.isRequestViaGateway()) {
            return;
        }
        http_msg.addHeader("x-trace-parent", ViaGatewayUtils.getRequestIdViaGateway());
        http_msg.addHeader("x-app-sticky", ViaGatewayUtils.getTraceChainIdViaGateway());
    }

    public static String getApiIdViaGateway() {
        return ViaGatewayUtils.getApiIdViaGateway(ViaGatewayUtils.getHttpServletRequest());
    }

    public static String getApiIdViaGateway(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return request.getHeader("x-api");
    }

    public static String getGatewayHost() {
        return ViaGatewayUtils.getGatewayHost(ViaGatewayUtils.getHttpServletRequest());
    }

    public static String getGatewayHost(HttpServletRequest request) {
        if (ViaGatewayUtils.isRequestViaGateway(request)) {
            String hostname = request.getHeader("x-host-override");
            if (StringUtils.isNotEmpty(hostname)) {
                return hostname;
            }
            hostname = request.getHeader("x-forwarded-host");
            if (StringUtils.isNotEmpty(hostname)) {
                return hostname;
            }
        }
        return request.getServerName();
    }

    public static String getGatewayId() {
        return ViaGatewayUtils.getGatewayId(ViaGatewayUtils.getHttpServletRequest());
    }

    public static String getGatewayId(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return request.getHeader("x-gateway-id");
    }

    public static String getRequestAppIdViaGateway() {
        return ViaGatewayUtils.getRequestAppIdViaGateway(ViaGatewayUtils.getHttpServletRequest());
    }

    public static String getRequestAppIdViaGateway(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return request.getHeader("x-app-id");
    }

    public static boolean isAppRequestViaGateway() {
        return StringUtils.isBlank(ViaGatewayUtils.getRequestUsernameViaGateway()) && StringUtils.isNoneBlank(ViaGatewayUtils.getRequestAppIdViaGateway());
    }

    public static boolean isAppRequestViaGateway(HttpServletRequest request) {
        return StringUtils.isBlank(ViaGatewayUtils.getRequestUsernameViaGateway(request)) && StringUtils.isNoneBlank(ViaGatewayUtils.getRequestAppIdViaGateway(request));
    }

    public static boolean isUserRequestViaGateway() {
        return !ViaGatewayUtils.isAppRequestViaGateway();
    }

    public static boolean isUserRequestViaGateway(HttpServletRequest request) {
        return !ViaGatewayUtils.isAppRequestViaGateway(request);
    }

    public static String getRequestUserIdViaGateway() {
        return ViaGatewayUtils.getRequestUserIdViaGateway(ViaGatewayUtils.getHttpServletRequest());
    }

    public static String getRequestUserIdViaGateway(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String userid = request.getHeader("x-credential-userid");
        return userid;
    }

    public static String getRequestUsernameViaGateway() {
        return ViaGatewayUtils.getRequestUsernameViaGateway(ViaGatewayUtils.getHttpServletRequest());
    }

    public static String getRequestUsernameViaGateway(HttpServletRequest request) {
        String username;
        block5: {
            if (request == null) {
                return null;
            }
            username = request.getHeader("iv-user");
            if (StringUtils.isBlank(username)) {
                username = request.getHeader("x-credential-username");
            }
            if (StringUtils.isNotBlank(username) && StringUtils.contains((CharSequence)username, "%")) {
                try {
                    username = URLDecoder.decode(username, "UTF-8");
                }
                catch (Throwable e) {
                    if (!Log.isDebugEnabled()) break block5;
                    Log.debug("URLDecoder.decode error: " + e.getMessage(), e);
                }
            }
        }
        return username;
    }

    public static String getRequestDisplayNameViaGateway(HttpServletRequest request) {
        String display_name;
        block4: {
            if (request == null) {
                return null;
            }
            display_name = request.getHeader("x-user-displayname");
            if (StringUtils.isNotBlank(display_name) && StringUtils.contains((CharSequence)display_name, "%")) {
                try {
                    display_name = URLDecoder.decode(display_name, "UTF-8");
                }
                catch (Throwable e) {
                    if (!Log.isDebugEnabled()) break block4;
                    Log.debug("URLDecoder.decode error: " + e.getMessage(), e);
                }
            }
        }
        return display_name;
    }

    public static String getRequestDisplayNameViaGateway() {
        return ViaGatewayUtils.getRequestDisplayNameViaGateway(ViaGatewayUtils.getHttpServletRequest());
    }

    @Deprecated
    public static String[] getRequestAclGroups() {
        return ViaGatewayUtils.getRequestAclGroups(ViaGatewayUtils.getHttpServletRequest());
    }

    @Deprecated
    public static String[] getRequestAclGroups(HttpServletRequest request) {
        if (request == null) {
            return new String[0];
        }
        String groups2 = request.getHeader("x-app-groups");
        String[] tmpret = StringUtils.split(groups2, ',');
        LinkedList<String> tmps = new LinkedList<String>();
        for (String tv : tmpret) {
            tmps.add(StringUtils.trim(tv));
        }
        return tmps.toArray(new String[0]);
    }

    public static String getReqeustRoot(HttpServletRequest request) {
        String proto = request.getScheme();
        StringBuffer sbf = new StringBuffer(proto);
        sbf.append("://").append(request.getServerName());
        int port = request.getServerPort();
        if (StringUtils.equalsIgnoreCase(proto, "http") && port != 80 || StringUtils.equalsIgnoreCase(proto, "https") && port != 443) {
            sbf.append(":").append(port);
        }
        return sbf.toString();
    }

    public static String getReqeustRoot() {
        return ViaGatewayUtils.getReqeustRoot(ViaGatewayUtils.getHttpServletRequest());
    }

    public static String getPublishURLViaGateway(String target_url) {
        return ViaGatewayUtils.getPublishURLViaGateway(ViaGatewayUtils.getHttpServletRequest(), target_url);
    }

    public static String getPublishURLViaGateway(HttpServletRequest request, String target_url) {
        if (ViaGatewayUtils.isRequestViaGateway(request)) {
            if (target_url.startsWith("//")) {
                return ViaGatewayUtils.getGatewayProto(request) + ":" + target_url;
            }
            if (target_url.startsWith("https://") || target_url.startsWith("http://")) {
                return target_url;
            }
            if (target_url.startsWith("/")) {
                return ViaGatewayUtils.getRequestRootViaGateway(request) + target_url;
            }
            return ViaGatewayUtils.getRequestRootViaGateway(request) + "/" + target_url;
        }
        if (target_url.startsWith("//")) {
            return request.getScheme() + ":" + target_url;
        }
        if (target_url.startsWith("https://") || target_url.startsWith("http://")) {
            return target_url;
        }
        if (target_url.startsWith("/")) {
            return ViaGatewayUtils.getReqeustRoot(request) + target_url;
        }
        return ViaGatewayUtils.getReqeustRoot(request) + "/" + target_url;
    }

    public static Map<String, Object> requestParametersToMap(HttpServletRequest request) {
        return ViaGatewayUtils.requestParametersToMap(request, null);
    }

    public static Map<String, Object> requestParametersToMap(HttpServletRequest request, Set<String> exclude_names) {
        LinkedHashMap<String, String> ext_properties = new LinkedHashMap<String, String>();
        Enumeration req_names = request.getParameterNames();
        while (req_names.hasMoreElements()) {
            String req_name = (String)req_names.nextElement();
            if (exclude_names != null && exclude_names.contains(req_name)) continue;
            ext_properties.put(req_name, request.getParameter(req_name));
        }
        if (ext_properties.size() == 0) {
            return null;
        }
        return new HashMap<String, Object>(ext_properties);
    }
}

