package gateway.api;


import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;

import org.apache.commons.io.IOUtils;

import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import retrofit2.Converter;

/**
 * JSON请求体转换器
 * 
 * @author neeker
 *
 * @param <T>
 */
final class GsonRequestBodyConverter<T> implements Converter<T, RequestBody> {
	
  private static final MediaType MEDIA_TYPE = MediaType.parse("application/json; charset=UTF-8");
  
  private static final Charset UTF_8 = Charset.forName("UTF-8");

  private final Gson gson;
  private final TypeAdapter<T> adapter;

  GsonRequestBodyConverter(Gson gson, TypeAdapter<T> adapter) {
    this.gson = gson;
    this.adapter = adapter;
  }

  @Override 
  public RequestBody convert(T value) throws IOException {
		Buffer buffer = new Buffer();
		try {
	    Writer writer = new OutputStreamWriter(buffer.outputStream(), UTF_8);
	    JsonWriter jsonWriter = gson.newJsonWriter(writer);
	    adapter.write(jsonWriter, value);
	    jsonWriter.close();
    return RequestBody.create(MEDIA_TYPE, buffer.readByteString());
		} finally {
			IOUtils.closeQuietly(buffer);			
		}
  }
  
}
