/*
 * Decompiled with CFR 0.152.
 */
package gateway.api;

import com.auth0.jwt.algorithms.Algorithm;
import com.google.gson.Gson;
import gateway.api.BytesConverterFactory;
import gateway.api.GsonConverterFactory;
import gateway.api.JsonUtils;
import gateway.api.JwtContext;
import gateway.api.OkHttpClientInterceptor;
import gateway.api.OkHttpClientJwtInterceptor;
import gateway.api.RSAUtils;
import gateway.api.SynchCallAdapterFactory;
import java.lang.reflect.Method;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import retrofit2.Retrofit;

public abstract class RetrofitUtils {
    private static final Log Log;
    private static Method GetWebSpringContextMethod;
    private static Method GetEnvironmentMethod;
    private static Method GetPropertyMethod;

    private static String doGetApiHelperCustomUserAgent() {
        if (GetWebSpringContextMethod == null || GetEnvironmentMethod == null || GetPropertyMethod == null) {
            return null;
        }
        try {
            Object val = GetWebSpringContextMethod.invoke(null, new Object[0]);
            val = GetEnvironmentMethod.invoke(val, new Object[0]);
            return (String)GetPropertyMethod.invoke(val, "app.client.user-agent");
        }
        catch (Throwable e) {
            if (Log.isDebugEnabled()) {
                Log.debug("get web application context error: " + e.getMessage());
            }
            return null;
        }
    }

    public static Retrofit createRetrofit(String apiprefix) {
        return RetrofitUtils.buildRetrofit(apiprefix, null, (Algorithm)null, new Interceptor[0]);
    }

    public static Retrofit.Builder createRetrofitBuilder(String apiprefix, Interceptor ... interceptors) {
        return RetrofitUtils.buildRetrofitBuilder(apiprefix, null, (Algorithm)null, interceptors);
    }

    public static Retrofit.Builder createRetrofitBuilder(String apiprefix) {
        return RetrofitUtils.createRetrofitBuilder(apiprefix, new Interceptor[0]);
    }

    public static Retrofit createRetrofit(String apiprefix, String jwtAppToken, String jwtPrivateKey, Interceptor ... interceptors) {
        return RetrofitUtils.createRetrofit(apiprefix, jwtAppToken, jwtPrivateKey, 1800, interceptors);
    }

    public static Retrofit buildRetrofit(String apiprefix, String jwtAppToken, Algorithm algorithm, Interceptor ... interceptors) {
        return RetrofitUtils.buildRetrofit(apiprefix, jwtAppToken, algorithm, 1800, interceptors);
    }

    public static Retrofit.Builder createRetrofitBuilder(String apiprefix, String jwtAppToken, String jwtPrivateKey) {
        return RetrofitUtils.createRetrofitBuilder(apiprefix, jwtAppToken, jwtPrivateKey, new Interceptor[0]);
    }

    public static Retrofit.Builder buildRetrofitBuilder(String apiprefix, String jwtAppToken, Algorithm algorithm) {
        return RetrofitUtils.buildRetrofitBuilder(apiprefix, jwtAppToken, algorithm, new Interceptor[0]);
    }

    public static Retrofit.Builder createRetrofitBuilder(String apiprefix, String jwtAppToken, String jwtPrivateKey, Interceptor ... interceptors) {
        return RetrofitUtils.createRetrofitBuilder(apiprefix, jwtAppToken, jwtPrivateKey, 180, interceptors);
    }

    public static Retrofit.Builder buildRetrofitBuilder(String apiprefix, String jwtAppToken, Algorithm algorithm, Interceptor ... interceptors) {
        return RetrofitUtils.buildRetrofitBuilder(apiprefix, jwtAppToken, algorithm, 180, interceptors);
    }

    public static Retrofit createRetrofit(String apiprefix, String jwtAppToken, String jwtPrivateKey, int jwtTokenLiveSeconds) {
        return RetrofitUtils.createRetrofit(apiprefix, jwtAppToken, jwtPrivateKey, jwtTokenLiveSeconds, new Interceptor[0]);
    }

    public static Retrofit buildRetrofit(String apiprefix, String jwtAppToken, Algorithm algorithm, int jwtTokenLiveSeconds) {
        return RetrofitUtils.buildRetrofit(apiprefix, jwtAppToken, algorithm, jwtTokenLiveSeconds, new Interceptor[0]);
    }

    public static Retrofit createRetrofit(String apiprefix, String jwtAppToken, String jwtPrivateKey, int jwtTokenLiveSeconds, Interceptor ... interceptors) {
        return RetrofitUtils.createRetrofit(apiprefix, jwtAppToken, jwtPrivateKey, jwtTokenLiveSeconds, JsonUtils.newGson(), "yyyy-MM-dd'T'HH:mm:ss.SSSZ", 180L, TimeUnit.SECONDS, interceptors);
    }

    public static Retrofit buildRetrofit(String apiprefix, String jwtAppToken, Algorithm algorithm, int jwtTokenLiveSeconds, Interceptor ... interceptors) {
        return RetrofitUtils.buildRetrofit(apiprefix, jwtAppToken, algorithm, jwtTokenLiveSeconds, JsonUtils.newGson(), "yyyy-MM-dd'T'HH:mm:ss.SSSZ", 180L, TimeUnit.SECONDS, interceptors);
    }

    public static Retrofit.Builder createRetrofitBuilder(String apiprefix, String jwtAppToken, String jwtPrivateKey, int jwtTokenLiveSeconds, Interceptor ... interceptors) {
        return RetrofitUtils.createRetrofitBuilder(apiprefix, jwtAppToken, jwtPrivateKey, jwtTokenLiveSeconds, JsonUtils.newGson(), "yyyy-MM-dd'T'HH:mm:ss.SSSZ", 180L, TimeUnit.SECONDS, interceptors);
    }

    public static Retrofit.Builder buildRetrofitBuilder(String apiprefix, String jwtAppToken, Algorithm algorithm, int jwtTokenLiveSeconds, Interceptor ... interceptors) {
        return RetrofitUtils.buildRetrofitBuilder(apiprefix, jwtAppToken, algorithm, jwtTokenLiveSeconds, JsonUtils.newGson(), "yyyy-MM-dd'T'HH:mm:ss.SSSZ", 180L, TimeUnit.SECONDS, interceptors);
    }

    public static Retrofit createRetrofit(String apiprefix, String jwtAppToken, String jwtPrivateKey, int jwtTokenLiveSeconds, Gson gson, String json_date_format, long timeout2, TimeUnit time_unit, Interceptor ... interceptors) {
        return RetrofitUtils.createRetrofitBuilder(apiprefix, jwtAppToken, jwtPrivateKey, jwtTokenLiveSeconds, gson, json_date_format, timeout2, time_unit, interceptors).build();
    }

    public static Retrofit buildRetrofit(String apiprefix, String jwtAppToken, Algorithm algorithm, int jwtTokenLiveSeconds, Gson gson, String json_date_format, long timeout2, TimeUnit time_unit, Interceptor ... interceptors) {
        return RetrofitUtils.buildRetrofitBuilder(apiprefix, jwtAppToken, algorithm, jwtTokenLiveSeconds, gson, json_date_format, timeout2, time_unit, interceptors).build();
    }

    public static Retrofit.Builder createRetrofitBuilder(String apiprefix, String jwtAppToken, String jwtPrivateKey, int jwtTokenLiveSeconds, Gson gson, String json_date_format, long timeout2, TimeUnit time_unit, Interceptor ... interceptors) {
        Algorithm algorithm = null;
        if (StringUtils.isNoneBlank(jwtPrivateKey)) {
            RSAKey rsa_key = (RSAKey)((Object)RSAUtils.parsePrivateKeyFromPEM(jwtPrivateKey));
            RSAPublicKey public_key = rsa_key instanceof RSAPublicKey ? (RSAPublicKey)rsa_key : null;
            RSAPrivateKey private_key = rsa_key instanceof RSAPrivateKey ? (RSAPrivateKey)rsa_key : null;
            algorithm = Algorithm.RSA256(public_key, private_key);
        }
        return RetrofitUtils.buildRetrofitBuilder(apiprefix, jwtAppToken, algorithm, jwtTokenLiveSeconds, gson, json_date_format, timeout2, time_unit, interceptors);
    }

    public static Retrofit.Builder buildRetrofitBuilder(String apiprefix, String jwtAppToken, Algorithm algorithm, int jwtTokenLiveSeconds, Gson gson, String json_date_format, long timeout2, TimeUnit time_unit, Interceptor ... interceptors) {
        if (Log.isDebugEnabled()) {
            Log.debug(String.format("apiprefix  = %s", apiprefix));
            Log.debug(String.format("apptoken   = %s", jwtAppToken));
            if (algorithm != null) {
                Log.debug(String.format("algorithm = %s", algorithm.getName()));
            }
        }
        JwtContext jwt_context = null;
        if (StringUtils.isNoneBlank(jwtAppToken) && algorithm != null) {
            jwt_context = JwtContext.create(jwtAppToken, algorithm, jwtTokenLiveSeconds);
        } else {
            Log.warn(MessageFormat.format("\u672a\u8bbe\u7f6e\u5bf9{0}\u7684JWT\u4ee4\u724c\u53c2\u6570\uff01", apiprefix));
        }
        String admin_url = apiprefix;
        if (!StringUtils.endsWith(admin_url, "/")) {
            admin_url = admin_url + "/";
        }
        OkHttpClient.Builder client_builder = new OkHttpClient.Builder();
        if (jwt_context != null) {
            client_builder.addInterceptor(new OkHttpClientJwtInterceptor(RetrofitUtils.doGetApiHelperCustomUserAgent(), jwt_context));
        } else {
            client_builder.addInterceptor(new OkHttpClientInterceptor(RetrofitUtils.doGetApiHelperCustomUserAgent()));
        }
        if (interceptors != null && interceptors.length > 0) {
            for (Interceptor interceptor : interceptors) {
                client_builder.addInterceptor(interceptor);
            }
        }
        client_builder.connectTimeout(timeout2, time_unit);
        client_builder.readTimeout(timeout2, time_unit);
        client_builder.writeTimeout(timeout2, time_unit);
        return new Retrofit.Builder().baseUrl(admin_url).addCallAdapterFactory(SynchCallAdapterFactory.create()).addConverterFactory(BytesConverterFactory.create()).addConverterFactory(GsonConverterFactory.create(gson, json_date_format)).client(client_builder.build());
    }

    static {
        block2: {
            Log = LogFactory.getLog(RetrofitUtils.class);
            GetWebSpringContextMethod = null;
            GetEnvironmentMethod = null;
            GetPropertyMethod = null;
            try {
                GetWebSpringContextMethod = Class.forName("org.springframework.web.context.ContextLoader").getMethod("getCurrentWebApplicationContext", new Class[0]);
                GetEnvironmentMethod = Class.forName("org.springframework.core.env.EnvironmentCapable").getMethod("getEnvironment", new Class[0]);
                GetPropertyMethod = Class.forName("org.springframework.core.env.PropertyResolver").getMethod("getProperty", String.class);
            }
            catch (Throwable e) {
                GetWebSpringContextMethod = null;
                GetEnvironmentMethod = null;
                GetPropertyMethod = null;
                if (!Log.isDebugEnabled()) break block2;
                Log.debug("Not run on web application!");
            }
        }
    }
}

