/*
 * Decompiled with CFR 0.152.
 */
package gateway.api;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import gateway.api.GsonRequestBodyConverter;
import gateway.api.GsonResponseBodyConverter;
import gateway.api.JsonUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.reflect.TypeUtils;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class GsonConverterFactory
extends Converter.Factory {
    private final Gson gson;
    private final DateToStringConverter dateToStringConverter;

    public static GsonConverterFactory create() {
        return GsonConverterFactory.create(JsonUtils.newGson(), "yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    }

    public static GsonConverterFactory create(Gson gson, String json_date_format) {
        if (gson == null) {
            throw new NullPointerException("gson == null");
        }
        return new GsonConverterFactory(gson, json_date_format);
    }

    private GsonConverterFactory(Gson gson, String json_date_format) {
        this.gson = gson;
        this.dateToStringConverter = new DateToStringConverter(json_date_format);
    }

    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        TypeAdapter adapter = this.gson.getAdapter(TypeToken.get((Type)type));
        return new GsonResponseBodyConverter(this.gson, adapter);
    }

    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        TypeAdapter adapter = this.gson.getAdapter(TypeToken.get((Type)type));
        return new GsonRequestBodyConverter(this.gson, adapter);
    }

    public Converter<?, String> stringConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        if (TypeUtils.isAssignable((Type)type, Date.class)) {
            return this.dateToStringConverter;
        }
        return super.stringConverter(type, annotations, retrofit);
    }

    public static final class DateToStringConverter
    implements Converter<Date, String> {
        public static final DateToStringConverter INSTANCE = new DateToStringConverter();
        private String json_date_format = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

        private DateToStringConverter() {
        }

        public DateToStringConverter(String json_date_format) {
            this.json_date_format = json_date_format;
        }

        public String convert(Date value) {
            if (value == null) {
                return null;
            }
            return new SimpleDateFormat(this.json_date_format).format(value);
        }
    }
}

