/*
 * Decompiled with CFR 0.152.
 */
package gateway.api;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.ByteString;
import org.apache.commons.io.IOUtils;
import retrofit2.Converter;

final class GsonRequestBodyConverter<T>
implements Converter<T, RequestBody> {
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json; charset=UTF-8");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Gson gson;
    private final TypeAdapter<T> adapter;

    GsonRequestBodyConverter(Gson gson, TypeAdapter<T> adapter) {
        this.gson = gson;
        this.adapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestBody convert(T value) throws IOException {
        Buffer buffer = new Buffer();
        try {
            OutputStreamWriter writer = new OutputStreamWriter(buffer.outputStream(), UTF_8);
            JsonWriter jsonWriter = this.gson.newJsonWriter((Writer)writer);
            this.adapter.write(jsonWriter, value);
            jsonWriter.close();
            RequestBody requestBody = RequestBody.create((MediaType)MEDIA_TYPE, (ByteString)buffer.readByteString());
            return requestBody;
        }
        finally {
            IOUtils.closeQuietly((Closeable)buffer);
        }
    }
}

