/*
 * Decompiled with CFR 0.152.
 */
package gateway.api;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.bind.util.ISO8601Utils;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class JsonDateTypeAdapter
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    private final DateFormat localFormat;
    private final DateFormat fixedFormat1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private final DateFormat fixedFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final DateFormat fixedFormat3 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final DateFormat fixedFormat4 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private final DateFormat fixedFormat5 = new SimpleDateFormat("yyyy-MM-dd");

    public JsonDateTypeAdapter(String datePattern) {
        this(new SimpleDateFormat(datePattern));
    }

    JsonDateTypeAdapter(DateFormat localFormat) {
        this.localFormat = localFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
        DateFormat dateFormat = this.localFormat;
        synchronized (dateFormat) {
            String dateFormatAsString = this.localFormat.format(src);
            return new JsonPrimitive(dateFormatAsString);
        }
    }

    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!(json instanceof JsonPrimitive)) {
            throw new JsonParseException("The date should be a string value");
        }
        Date date = this.deserializeToDate(json);
        if (typeOfT == Date.class) {
            return date;
        }
        if (typeOfT == Timestamp.class) {
            return new Timestamp(date.getTime());
        }
        if (typeOfT == java.sql.Date.class) {
            return new java.sql.Date(date.getTime());
        }
        throw new IllegalArgumentException(this.getClass() + " cannot deserialize to " + typeOfT);
    }

    private Date deserializeToDate(JsonElement json) {
        DateFormat dateFormat = this.localFormat;
        synchronized (dateFormat) {
            try {
                return this.localFormat.parse(json.getAsString());
            }
            catch (ParseException parseException) {
                try {
                    return this.fixedFormat1.parse(json.getAsString());
                }
                catch (ParseException parseException2) {
                    try {
                        return this.fixedFormat2.parse(json.getAsString());
                    }
                    catch (ParseException parseException3) {
                        try {
                            return this.fixedFormat3.parse(json.getAsString());
                        }
                        catch (ParseException parseException4) {
                            try {
                                return this.fixedFormat4.parse(json.getAsString());
                            }
                            catch (ParseException parseException5) {
                                try {
                                    return this.fixedFormat5.parse(json.getAsString());
                                }
                                catch (ParseException parseException6) {
                                    try {
                                        return ISO8601Utils.parse((String)json.getAsString(), (ParsePosition)new ParsePosition(0));
                                    }
                                    catch (ParseException e) {
                                        throw new JsonSyntaxException(json.getAsString(), (Throwable)e);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(JsonDateTypeAdapter.class.getSimpleName());
        sb.append('(').append(this.localFormat.getClass().getSimpleName()).append(')');
        return sb.toString();
    }
}

