/*
 * Decompiled with CFR 0.152.
 */
package gateway.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import gateway.api.JsonDateTypeAdapter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Date;

public abstract class JsonUtils {
    public static final String JsonDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    @Deprecated
    private static final JsonDateTypeAdapter DefaultJsonDateTypeAdapter = new JsonDateTypeAdapter("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static final Charset JsonCharset = Charset.forName("UTF-8");
    @Deprecated
    private static Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").registerTypeAdapter(Date.class, (Object)DefaultJsonDateTypeAdapter).registerTypeAdapter(java.sql.Date.class, (Object)DefaultJsonDateTypeAdapter).create();

    @Deprecated
    public static Gson getGson() {
        return gson;
    }

    public static Gson newGson() {
        return new GsonBuilder().enableComplexMapKeySerialization().setDateFormat(JsonDateFormat).registerTypeAdapter(Date.class, (Object)new JsonDateTypeAdapter(JsonDateFormat)).registerTypeAdapter(java.sql.Date.class, (Object)new JsonDateTypeAdapter(JsonDateFormat)).create();
    }

    public static <T> String toJson(T object) {
        return JsonUtils.newGson().toJson(object);
    }

    public static <T> T fromJson(String json, Class<T> toClass) {
        return (T)JsonUtils.newGson().fromJson(json, toClass);
    }

    public static <T> T fromJson(String json, Type toClass) {
        return (T)JsonUtils.newGson().fromJson(json, toClass);
    }

    public static <T> T fromJson(InputStream reader, Class<T> toClass) {
        return (T)JsonUtils.newGson().fromJson((Reader)new InputStreamReader(reader), toClass);
    }

    public static <T> T fromJson(InputStream reader, Type toClass) {
        return (T)JsonUtils.newGson().fromJson((Reader)new InputStreamReader(reader), toClass);
    }

    public static <T> T fromJson(JsonElement el, Class<T> toClass) {
        return (T)JsonUtils.newGson().fromJson(el, toClass);
    }

    public static <T> T fromJson(JsonElement el, Type type) {
        return (T)JsonUtils.newGson().fromJson(el, type);
    }
}

