/*
 * Decompiled with CFR 0.152.
 */
package gateway.api;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import gateway.api.JwtToken;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Calendar;
import java.util.Date;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class JwtContext {
    private String appToken;
    private int tokenLiveSconds = 1200;
    private Algorithm algorithm;

    JwtContext(String appToken, int tokenLiveSconds, Algorithm algorithm) {
        this.appToken = appToken;
        this.tokenLiveSconds = tokenLiveSconds;
        this.algorithm = algorithm;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public int getTokenLiveSconds() {
        return this.tokenLiveSconds;
    }

    public void setTokenLiveSconds(int tokenLiveSconds) {
        this.tokenLiveSconds = tokenLiveSconds;
    }

    public JwtToken createJwtToken() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, this.tokenLiveSconds);
        String jwt_token = JWT.create().withIssuer(this.getAppToken()).withExpiresAt(calendar.getTime()).sign(this.algorithm);
        JwtToken rtoken = new JwtToken(jwt_token, new Date(), calendar.getTime());
        return rtoken;
    }

    public static JwtContext create(String app_token, RSAKey rsa_key, int token_live_seconds) {
        RSAPublicKey public_key = rsa_key instanceof RSAPublicKey ? (RSAPublicKey)rsa_key : null;
        RSAPrivateKey private_key = rsa_key instanceof RSAPrivateKey ? (RSAPrivateKey)rsa_key : null;
        JwtContext w = new JwtContext(app_token, token_live_seconds, Algorithm.RSA256((RSAPublicKey)public_key, (RSAPrivateKey)private_key));
        return w;
    }

    public static JwtContext create(String app_token, Algorithm algorithm, int token_live_seconds) {
        JwtContext w = new JwtContext(app_token, token_live_seconds, algorithm);
        return w;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

