/*
 * Decompiled with CFR 0.152.
 */
package gateway.api;

import java.io.Serializable;
import java.util.Date;

public class JwtToken
implements Serializable {
    private static final long serialVersionUID = 2545258825711201640L;
    private String jwtToken;
    private Date createTime;
    private Date expireTime;

    JwtToken(String jwtToken, Date createTime, Date expireTime) {
        this.jwtToken = jwtToken;
        this.createTime = createTime;
        this.expireTime = expireTime;
    }

    boolean isExpired() {
        return !this.expireTime.after(new Date());
    }

    public String getJwtToken() {
        return this.jwtToken;
    }

    public String toParameterString() {
        return "jwt=" + this.getJwtToken();
    }

    public String toAuthorizationString() {
        return "Bearer " + this.getJwtToken();
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getExpireTime() {
        return this.expireTime;
    }

    public String toString() {
        return "JWTToken [jwtToken=" + this.jwtToken + ", createTime=" + this.createTime + ", expireTime=" + this.expireTime + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.jwtToken == null ? 0 : this.jwtToken.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JwtToken other = (JwtToken)obj;
        return !(this.jwtToken == null ? other.jwtToken != null : !this.jwtToken.equals(other.jwtToken));
    }
}

