/*
 * Decompiled with CFR 0.152.
 */
package cn.starrys.util.mail;

import cn.starrys.util.mail.entity.Mail;
import cn.starrys.util.mail.entity.MailAddress;
import cn.starrys.util.mail.entity.MailProps;
import com.sun.mail.util.MailSSLSocketFactory;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class MailUtils {
    private static Session getSession(final Properties props) {
        if (Boolean.parseBoolean(props.getProperty("mail." + props.getProperty("protocol") + ".auth"))) {
            return Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(props.getProperty("mail.from"), props.getProperty("mail.password"));
                }
            });
        }
        return Session.getDefaultInstance((Properties)props);
    }

    public static Session getSession(MailProps mailProps) {
        String protocol = mailProps.getProtocol();
        String host = mailProps.getHost();
        String from = mailProps.getFrom();
        String password = mailProps.getPassword();
        String nickname = mailProps.getNickname();
        Integer port = mailProps.getPort();
        boolean ssl = mailProps.isSsl();
        boolean auth = mailProps.isAuth();
        boolean debug = mailProps.isDebug();
        Properties props = new Properties();
        props.setProperty("protocol", protocol);
        switch (protocol) {
            case "imap": 
            case "pop3": {
                props.setProperty("mail.store.protocol", protocol);
                break;
            }
            default: {
                props.setProperty("mail.transport.protocol", protocol);
            }
        }
        props.setProperty("mail.host", host);
        props.setProperty("mail.from", from);
        props.setProperty("mail.password", password);
        if (null != nickname) {
            props.setProperty("mail.user", nickname);
        }
        if (null != port) {
            props.setProperty("mail." + protocol + ".port", port.toString());
        }
        if (ssl) {
            try {
                MailSSLSocketFactory mailSSLSocketFactory = new MailSSLSocketFactory();
                mailSSLSocketFactory.setTrustedHosts(new String[]{host});
                props.setProperty("mail." + protocol + ".ssl.enable", "true");
                props.setProperty("mail." + protocol + ".ssl.socketFactory", mailSSLSocketFactory.toString());
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
        }
        if (auth) {
            props.setProperty("mail." + protocol + ".auth", "true");
        }
        if (debug) {
            props.setProperty("mail.debug", "true");
        }
        return MailUtils.getSession(props);
    }

    public static MimeMessage createMessage(Session session, Mail mail) throws UnsupportedEncodingException, MessagingException {
        List<MailAddress> mailBcc;
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom((Address)new InternetAddress(session.getProperty("mail.from"), session.getProperty("mail.user"), "UTF-8"));
        List<MailAddress> mailTo = mail.getTo();
        if (mailTo == null) {
            throw new MessagingException("\u81f3\u5c11\u9700\u8981\u4e00\u4f4d\u6536\u4ef6\u4eba");
        }
        InternetAddress[] to = new InternetAddress[mailTo.size()];
        for (int i = 0; i < to.length; ++i) {
            MailAddress addressee = mailTo.get(i);
            to[i] = new InternetAddress(addressee.getAddress(), addressee.getNickname(), "UTF-8");
        }
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])to);
        List<MailAddress> mailCc = mail.getCc();
        if (mailCc != null) {
            InternetAddress[] cc = new InternetAddress[mailCc.size()];
            for (int i = 0; i < cc.length; ++i) {
                MailAddress addressee = mailCc.get(i);
                cc[i] = new InternetAddress(addressee.getAddress(), addressee.getNickname(), "UTF-8");
            }
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])cc);
        }
        if ((mailBcc = mail.getBcc()) != null) {
            InternetAddress[] bcc = new InternetAddress[mailBcc.size()];
            for (int i = 0; i < bcc.length; ++i) {
                MailAddress addressee = mailBcc.get(i);
                bcc[i] = new InternetAddress(addressee.getAddress(), addressee.getNickname(), "UTF-8");
            }
            mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])bcc);
        }
        mimeMessage.setSubject(mail.getSubject());
        MimeMultipart mimeMultipart = new MimeMultipart();
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent((Object)mail.getBody(), "text/html;charset=utf-8");
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        List<File> attachments = mail.getAttachments();
        try {
            for (File attachment : attachments) {
                MimeBodyPart fileBodyPart = new MimeBodyPart();
                fileBodyPart.attachFile(attachment);
                mimeMultipart.addBodyPart((BodyPart)fileBodyPart);
            }
        }
        catch (Exception e) {
            System.err.println("\u6dfb\u52a0\u9644\u4ef6\u5931\u8d25");
            e.printStackTrace();
        }
        mimeMessage.setContent((Multipart)mimeMultipart);
        mimeMessage.setSentDate(new Date());
        mimeMessage.saveChanges();
        return mimeMessage;
    }
}

