/*
 * Decompiled with CFR 0.152.
 */
package cn.starrys.json;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Gson gson = new GsonBuilder().serializeNulls().create();

    private static String[] split(String keyPath) {
        return keyPath.split("\\.");
    }

    public static <T> T getValue(String jsonStr, String keyPath, Class<T> type) {
        String[] keys;
        for (String key : keys = JsonUtils.split(keyPath)) {
            JSONObject jsonObject = JSON.parseObject((String)jsonStr);
            int begin = key.indexOf(91);
            int end = key.lastIndexOf(93);
            if (begin != -1 && end != -1) {
                String k = key.substring(0, begin);
                int i = Integer.parseInt(key.substring(begin + 1, end));
                try {
                    jsonStr = jsonObject.getJSONArray(k).getString(i);
                }
                catch (IndexOutOfBoundsException e) {
                    log.error("\u6570\u7ec4\u8d8a\u754c", (Throwable)e);
                }
                continue;
            }
            jsonStr = jsonObject.getString(key);
        }
        try {
            return (T)JSON.to(type, (Object)jsonStr);
        }
        catch (JSONException e) {
            log.error("\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static <T> T getValue2(String jsonStr, String keyPath, Class<T> type) {
        String[] keys = JsonUtils.split(keyPath);
        try {
            JsonNode jsonNode = objectMapper.readTree(jsonStr);
            for (String key : keys) {
                int begin = key.indexOf(91);
                int end = key.lastIndexOf(93);
                if (begin != -1 && end != -1) {
                    String k = key.substring(0, begin);
                    int i = Integer.parseInt(key.substring(begin + 1, end));
                    jsonNode = jsonNode.get(k).get(i);
                    continue;
                }
                jsonNode = jsonNode.get(key);
            }
            return (T)objectMapper.treeToValue((TreeNode)jsonNode, type);
        }
        catch (JsonProcessingException e) {
            log.error("Json\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
        catch (NullPointerException e) {
            log.error("\u53d1\u751f\u4e86\u7a7a\u6307\u9488\uff1a\u4e5f\u8bb8\u662f\u4e0b\u6807\u8d8a\u754c\u9020\u6210\u7684", (Throwable)e);
        }
        return null;
    }

    public static <T> T getValue3(String jsonStr, String keyPath, Class<T> type) {
        String[] keys;
        for (String key : keys = JsonUtils.split(keyPath)) {
            JsonObject jsonObject = JsonParser.parseString((String)jsonStr).getAsJsonObject();
            int begin = key.indexOf(91);
            int end = key.lastIndexOf(93);
            if (begin != -1 && end != -1) {
                String k = key.substring(0, begin);
                int i = Integer.parseInt(key.substring(begin + 1, end));
                try {
                    jsonStr = jsonObject.get(k).getAsJsonArray().get(i).toString();
                }
                catch (IllegalStateException e) {
                    log.error("{} \u5e76\u975e\u6570\u7ec4", (Object)k, (Object)e);
                }
                catch (IndexOutOfBoundsException e) {
                    log.error("\u6570\u7ec4\u8d8a\u754c", (Throwable)e);
                }
                continue;
            }
            jsonStr = jsonObject.get(key).toString();
        }
        return (T)gson.fromJson(jsonStr, type);
    }
}

