/*
 * Decompiled with CFR 0.152.
 */
package cn.starrys.json;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONObject;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonTools {
    private static final Logger log = LoggerFactory.getLogger(JsonTools.class);

    @Contract(pure=true)
    private static String @NotNull [] split(@NotNull String keyPath) {
        return keyPath.split("\\.");
    }

    @Nullable
    public static <T> T getValue(String jsonStr, String keyPath, Class<T> type) {
        String[] keys;
        for (String key : keys = JsonTools.split(keyPath)) {
            JSONObject jsonObject = JSON.parseObject((String)jsonStr);
            int begin = key.indexOf(91);
            int end = key.lastIndexOf(93);
            if (begin != -1 && end != -1) {
                String k = key.substring(0, begin);
                int i = Integer.parseInt(key.substring(begin + 1, end));
                try {
                    jsonStr = jsonObject.getJSONArray(k).getString(i);
                }
                catch (IndexOutOfBoundsException e) {
                    log.error("\u6570\u7ec4\u8d8a\u754c", (Throwable)e);
                }
                continue;
            }
            jsonStr = jsonObject.getString(key);
        }
        try {
            return (T)JSON.to(type, (Object)jsonStr);
        }
        catch (JSONException e) {
            log.error("\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }
}

